// 
//
// (c) 2009 iSpeech Inc.
// No portion of this material can be redistributed 
// without the explicit permission of iSpeech Inc.
//
// 
// Version 1.0
//

using System;
using System.Web;
using BlogEngine.Core;

[BlogEngine.Core.Web.Controls.Extension("Adds the iSpeech Listen button to the top of your posts.", "1.0", "<a href='http://www.ispeech.org'>iSpeech.org</a>")]
public class iSpeech
{
	private int postIndex=0;
	public iSpeech()
	{
		// init 
		this.postIndex=0; 
		Post.Serving += new EventHandler<ServingEventArgs>(Posts);				
	}
	private void Posts(object sender, ServingEventArgs e)
	{
		if(this.postIndex>100000)
			this.postIndex=1;
		if(e.Location == ServingLocation.PostList || e.Location==ServingLocation.SinglePost)
		{
			Post p = (Post)sender;
			e.Body = this.iSpeechPlayer(p.AbsoluteLink.ToString()) + e.Body;			
			
			// add to header			
			HttpContext ctx = HttpContext.Current;
			if(ctx.Items["ispeech"]==null)
			{
				System.Web.UI.Page page = (System.Web.UI.Page)ctx.CurrentHandler;
				page.Header.Controls.Add(new System.Web.UI.LiteralControl( "<script type=\"text/javascript\" src=\"http://www.ispeech.org/scripts/scripts.php?ver=1.0&src=ble\"></script>"));
				ctx.Items["ispeech"]=true;
			}

		}
	}
	
	private string iSpeechPlayer(string perma)
	{
		this.postIndex++;
        string t="<img src=\"http://www.ispeech.org/images/listen.gif\" alt=\"Listen to this Post. Powered by iSpeech.org\" title=\"Listen to this Post. Powered by iSpeech.org\" style=\"cursor: pointer;\" onclick=\"showPlayer({1},'{0}')\" height=\"18\" width=\"77\"><br><iframe style=\"border: none ; overflow: hidden; width: 0px; height: 0px;\" id=\"ispeech_iframe_{1}\" frameborder=\"0\"></iframe><br/>";
		return string.Format(t,perma,this.postIndex.ToString());
	}
}