<?php
/*
Plugin Name: iSpeech Listen Button
Plugin URI: http://www.ispeech.org/wordpress.php
Description: Let your visitors HEAR what you write about! Adds a "Listen" button to every post. 
Author: iSpeech
Version: 2.0
Author URI: http://www.ispeech.org/

Version History:
2.0 Total System Upgrade
2.1 Fixed issue with html formatting

*/
define('ISC_PLUGIN_NAME',"iSpeech Listen Button");
define('ISC_DEFAULT_KEY',"default-ispeech-listenbutton-key");
define('ISC_PLUGIN_ID',"iswrPlugin");
if(!class_exists('iswrPlugin')):
define('ISC_VERSION',"2.1");
//remove_filter ('the_content', 'wpautop');

class iswrPlugin
{
    static function addbutton($content)
    {   
       // $content=wpautop($content);
        if(is_feed()||!in_the_loop()) return $content;
       $id=get_the_ID();
       $options = get_option(ISC_PLUGIN_ID .'_options');        
       $spanId  ="iswpReadMe_$id";
       $hl = $options['highlighting'];
       $link = iswrPlugin::get_link();
       //
       //  We offer a free service, we are able to do this because of the link.
       //  Please do not remove the link, you can style it to make 
       //  it smaller or fit your design, but not remove or hide
       //
       $link ="<a href=\"{$link['link']}\" target=\"_blank\" style=\"font-size:10px;line-height:10px\">{$link['text']}</a><br/>";
       if($options['ads']==1) $link="";
       $speed=$options['speed'];
       $voice=iswrPlugin::get_voice();
       $script = <<<endl
<script type="text/javascript">var isJsHost="https:"==document.location.protocol?"https://":"http://";if(typeof window.iSpeechWebReaderInit=="undefined"||window.iSpeechWebReaderInit.length==0)window.iSpeechWebReaderInit=[];window.iSpeechWebReaderInit[window.iSpeechWebReaderInit.length]=function(e){if(typeof window.webReader=="undefined"||window.webReader.length==0)window.webReader=[];window.webReader[e]=new iSpeechWebReader({apiKey:"{$options['apikey']}",enableHighlight:!(!$hl), speed:$speed,content:"+#title{$spanId};+#{$spanId}",id:e,voice:"$voice",lc:window.location})},document.write('<script src="'+isJsHost+'www.ispeech.org/scripts/iSpeechHighlighter.js" type="text/javascript"></s'+"cript>");</script><br/>$link
endl;
       return "$script<span id=\"$spanId\">$content</span>"; 
       
    }
    static function title($title,$id)
    {   
        if(is_feed()||!in_the_loop()) return $title;                               
        return"<span id=\"titleiswpReadMe_$id\">$title</span>";        
    }
    static function options()
    {
        if (!current_user_can('manage_options'))                
            wp_die( __('You do not have sufficient permissions to access this page.') );
        iswrPlugin::options_html();
    }
   static function admin_menu()
   {
        add_options_page('Listen Button Options', "Listen Button", 'manage_options', ISC_PLUGIN_ID, array(ISC_PLUGIN_ID, 'options'));
   }
   static function validate($options)
   {
       $options['apikey'] = iswrPlugin::apikey_validate(trim($options['apikey']));
       if($options['apikey']==ISC_DEFAULT_KEY)
       {
           $options['highlighting']=0;
           $options['ads']=0;
           $options['speed']=0;
       }
       return $options;
   }
   static function get_voice()
   {
       $v=array("usenglishfemale", "usenglishmale", "ukenglishfemale", "ukenglishmale", "auenglishfemale", "usspanishfemale", "usspanishmale", "chchinesefemale", "chchinesemale", "hkchinesefemale", "twchinesefemale", "eurcatalanfemale", "eurczechfemale", "eurdanishfemale", "eurfinnishfemale", "eurfrenchfemale", "eurfrenchmale", "eurnorwegianfemale", "eurdutchfemale", "eurpolishfemale", "euritalianfemale", "euritalianmale", "jpjapanesefemale", "jpjapanesemale", "krkoreanfemale", "krkoreanmale", "caenglishfemale", "huhungarianfemale", "brportuguesefemale", "eurportuguesefemale", "eurportuguesemale", "eurspanishfemale", "eurspanishmale", "eurturkishfemale", "eurturkishmale", "eurgreekfemale", "eurgermanfemale", "eurgermanmale", "rurussianfemale", "rurussianmale", "swswedishfemale", "cafrenchfemale", "cafrenchmale", "arabicmale");
       $options = get_option(ISC_PLUGIN_ID .'_options'); 
       return $v[(int)$options['voice']];
   }
   static function admin_init()
   {
       $options = get_option(ISC_PLUGIN_ID .'_options'); 
        register_setting(ISC_PLUGIN_ID .'_options',ISC_PLUGIN_ID .'_options',array(ISC_PLUGIN_ID, 'validate'));
        add_settings_section('plugin_main', 'Settings',array(ISC_PLUGIN_ID, 'section_text'), ISC_PLUGIN_ID);
        add_settings_field("apikey","API Key:",array(ISC_PLUGIN_ID,"apikey_default"),ISC_PLUGIN_ID,'plugin_main');
        add_settings_field("voice","Voice:",array(ISC_PLUGIN_ID,"voice_default"),ISC_PLUGIN_ID,'plugin_main');
        if($options['apikey']=iswrPlugin::apikey_validate(trim($options['apikey']))!=ISC_DEFAULT_KEY)
        {
            add_settings_field("highlighting","Highlighting:",array(ISC_PLUGIN_ID,"highlighting_default"),ISC_PLUGIN_ID,'plugin_main');
            add_settings_field("speed","Speed:",array(ISC_PLUGIN_ID,"speed_default"),ISC_PLUGIN_ID,'plugin_main');
            add_settings_field("ads","Ads:",array(ISC_PLUGIN_ID,"ads_default"),ISC_PLUGIN_ID,'plugin_main');
        }
   }
   static function section_text()
   {
        
   }
   static function apikey_validate($key)
   {
       if($key ==false || strlen($key)!=32)
            $key =ISC_DEFAULT_KEY;        
       return strtolower($key);
   }
   static function voice_default()
   {
        $options = get_option(ISC_PLUGIN_ID .'_options');    
        ?><select id='voice' name='<?php echo ISC_PLUGIN_ID;?>_options[voice]'>
<option value="0"<?php echo ($options['voice']==0?" selected='selected'":"") ?>>US English Female</option>
<option value="1"<?php echo ($options['voice']==1?" selected='selected'":"") ?>>US English Male</option>
<option value="2"<?php echo ($options['voice']==2?" selected='selected'":"") ?>>UK English Female</option>
<option value="3"<?php echo ($options['voice']==3?" selected='selected'":"") ?>>UK English Male</option>
<option value="4"<?php echo ($options['voice']==4?" selected='selected'":"") ?>>AU English Female</option>
<option value="5"<?php echo ($options['voice']==5?" selected='selected'":"") ?>>US Spanish Female</option>
<option value="6"<?php echo ($options['voice']==6?" selected='selected'":"") ?>>US Spanish Male</option>
<option value="7"<?php echo ($options['voice']==7?" selected='selected'":"") ?>>Chinese Female</option>
<option value="8"<?php echo ($options['voice']==8?" selected='selected'":"") ?>>Chinese Male</option>
<option value="9"<?php echo ($options['voice']==9?" selected='selected'":"") ?>>Catonese Female</option>
<option value="10"<?php echo ($options['voice']==10?" selected='selected'":"") ?>>Taiwan Female</option>
<option value="11"<?php echo ($options['voice']==11?" selected='selected'":"") ?>>Catalan Female</option>
<option value="12"<?php echo ($options['voice']==12?" selected='selected'":"") ?>>Czech Female</option>
<option value="13"<?php echo ($options['voice']==13?" selected='selected'":"") ?>>Danish Female</option>
<option value="14"<?php echo ($options['voice']==14?" selected='selected'":"") ?>>Finnish Female</option>
<option value="15"<?php echo ($options['voice']==15?" selected='selected'":"") ?>>French Female</option>
<option value="16"<?php echo ($options['voice']==16?" selected='selected'":"") ?>>French Male</option>
<option value="17"<?php echo ($options['voice']==17?" selected='selected'":"") ?>>Norweigian Female</option>
<option value="18"<?php echo ($options['voice']==18?" selected='selected'":"") ?>>Dutch Female</option>
<option value="19"<?php echo ($options['voice']==19?" selected='selected'":"") ?>>Polish Female</option>
<option value="20"<?php echo ($options['voice']==20?" selected='selected'":"") ?>>Italian Female</option>
<option value="21"<?php echo ($options['voice']==21?" selected='selected'":"") ?>>Italian Male</option>
<option value="22"<?php echo ($options['voice']==22?" selected='selected'":"") ?>>Japanese Female</option>
<option value="23"<?php echo ($options['voice']==23?" selected='selected'":"") ?>>Japanese Male</option>
<option value="24"<?php echo ($options['voice']==24?" selected='selected'":"") ?>>Korean Female</option>
<option value="25"<?php echo ($options['voice']==25?" selected='selected'":"") ?>>Korean Male</option>
<option value="26"<?php echo ($options['voice']==26?" selected='selected'":"") ?>>CA English Female</option>
<option value="27"<?php echo ($options['voice']==27?" selected='selected'":"") ?>>Hungarian Female</option>
<option value="28"<?php echo ($options['voice']==28?" selected='selected'":"") ?>>BR Portuguese Female</option>
<option value="29"<?php echo ($options['voice']==29?" selected='selected'":"") ?>>EU Portuguese Female</option>
<option value="30"<?php echo ($options['voice']==30?" selected='selected'":"") ?>>EU Portuguese Male</option>
<option value="31"<?php echo ($options['voice']==31?" selected='selected'":"") ?>>Spain Spanish Female</option>
<option value="32"<?php echo ($options['voice']==32?" selected='selected'":"") ?>>Spain Spanish Male</option>
<option value="33"<?php echo ($options['voice']==33?" selected='selected'":"") ?>>Turkish Female</option>
<option value="34"<?php echo ($options['voice']==34?" selected='selected'":"") ?>>Turkish Male</option>
<option value="35"<?php echo ($options['voice']==35?" selected='selected'":"") ?>>Greek Female</option>
<option value="36"<?php echo ($options['voice']==36?" selected='selected'":"") ?>>German Female</option>
<option value="37"<?php echo ($options['voice']==37?" selected='selected'":"") ?>>German Male</option>
<option value="38"<?php echo ($options['voice']==38?" selected='selected'":"") ?>>Russian Female</option>
<option value="39"<?php echo ($options['voice']==39?" selected='selected'":"") ?>>Russian Male</option>
<option value="40"<?php echo ($options['voice']==40?" selected='selected'":"") ?>>Swedish Female</option>
<option value="41"<?php echo ($options['voice']==41?" selected='selected'":"") ?>>CA French Female</option>
<option value="42"<?php echo ($options['voice']==42?" selected='selected'":"") ?>>CA French Male</option>
<option value="43"<?php echo ($options['voice']==43?" selected='selected'":"") ?>>Arabic Male</option>
        </select><?php
   }
   static function speed_default()
   {
        $options = get_option(ISC_PLUGIN_ID .'_options'); 
        echo "<select id='speed' name='". ISC_PLUGIN_ID."_options[speed]'><option value='-2'".($options['speed']==-2?" selected='selected'":"").">Slowest</option><option value='-1'".($options['speed']==-1?" selected='selected'":"").">Slower</option><option value='0'".($options['speed']==0?"selected='selected'":"").">Normal</option><option value='1'".($options['speed']==1?" selected='selected'":"").">Faster</option><option value='2'".($options['speed']==2?" selected='selected'":"").">Fastest</option></select>";
   }
   static function ads_default()
   {
        $options = get_option(ISC_PLUGIN_ID .'_options');    
        echo "<label for='ads_1'><input id='ads_1' name='". ISC_PLUGIN_ID."_options[ads]' size='40' type='radio' value='1' ". ($options['ads']==1?"checked='checked'":"") ."/>Disabled</label> &nbsp; <label for='ads_0'><input id='ads_0' name='". ISC_PLUGIN_ID."_options[ads]' size='40' type='radio' value='0' ". ($options['ads']==0?"checked='checked'":"") ."/>Enabled</label>";
   }
   static function apikey_default()
   {
        $options = get_option(ISC_PLUGIN_ID .'_options');   
        $options['apikey']=iswrPlugin::apikey_validate(trim($options['apikey']));             
        echo "<input id='apikey' name='". ISC_PLUGIN_ID."_options[apikey]' size='40' type='text' value='{$options['apikey']}' />";
        
   }
   static function highlighting_default()
   {
       $options = get_option(ISC_PLUGIN_ID .'_options');        
       echo "<label for='highlighting_1'><input id='highlighting_1' name='". ISC_PLUGIN_ID."_options[highlighting]' size='40' type='radio' value='1' ". ($options['highlighting']==1?"checked='checked'":"") ."/>Enabled</label> &nbsp; <label for='highlighting_0'><input id='highlighting_0' name='". ISC_PLUGIN_ID."_options[highlighting]' size='40' type='radio' value='0' ". ($options['highlighting']==0?"checked='checked'":"") ."/>Disabled</label>";
   }
        
   // please do not modify, this is how we can offer this for free!
   private static function get_link()
   {
       global $id;
       $links=array(
            array('weight'=>'0.4','link' =>"http://www.ispeech.org/",'text'=>'http://www.ispeech.org'),
            array('weight'=>'0.2','link' =>"http://www.ispeech.org/text.to.speech",'text'=>'http://www.ispeech.org/text.to.speech'),
            array('weight'=>'0.1','link' =>"http://www.ispeech.org/",'text'=>'Text to Speech'),
            array('weight'=>'0.01','link' =>"http://www.ispeech.org/",'text'=>'text to speech'),
            array('weight'=>'0.04','link' =>"http://www.ispeech.org/",'text'=>'TTS'),
            array('weight'=>'0.005','link' =>"http://www.ispeech.org/",'text'=>'tts'),
            array('weight'=>'0.01','link' =>"http://www.ispeech.org/",'text'=>'Text to Voice'),
            array('weight'=>'0.01','link' =>"http://www.ispeech.org/",'text'=>'Speech Synthesis'),
            array('weight'=>'0.02','link' =>"http://www.ispeech.org/",'text'=>'Text to Speech Voices'),
            array('weight'=>'0.03','link' =>"http://www.ispeech.org/",'text'=>'Convert Text to Speech'),
            array('weight'=>'0.01','link' =>"http://www.ispeech.org/",'text'=>'Free Text to Speech'),
            array('weight'=>'0.05','link' =>"http://www.ispeech.org/",'text'=>'iSpeech'),
            array('weight'=>'0.05','link' =>"http://www.ispeech.org/",'text'=>'Powered by iSpeech'),
            array('weight'=>'0.02','link' =>"http://www.ispeech.org/text.to.speech",'text'=>'Text to Speech Demo'),
            array('weight'=>'0.018','link' =>"http://www.ispeech.org/text.to.speech",'text'=>'TTS Demo'),
            array('weight'=>'0.002','link' =>"http://www.ispeech.org/",'text'=>'english text to speech voices'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'spanish text to speech voices'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'english text to speech'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'uk text to speech'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'british tts'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'british text to speech'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'arabic tts'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'german tts'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'german text to speech'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'brazillian text to speech'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'portuguese text to speech'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'portuguese tts'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'french tts'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'french text to speech'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'chinese tts'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'japanese text to speech'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'chinese text to speech'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'korean tts'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'korean text to speech'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'australian text to speech'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'natural text to speech'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'natural tts'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'high definition text to speech'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'high definition tts'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'dutch tts'),
            array('weight'=>'0.001','link' =>"http://www.ispeech.org/",'text'=>'dutch text to speech')
        );

        $rt=0;
        mt_srand($id);        
        $r = mt_rand(1,1000);     
        foreach($links as $link)
        {            
            $rt=bcadd(bcmul($link['weight'],1000),$rt);  
            if($r<=$rt)            
                return $link;            
        }
        return $links[0];

   }
   private static function options_html()
   {        
        echo '<div class="wrap"><h2>'. ISC_PLUGIN_NAME .'</h2><form method="post" action="options.php">';
        settings_fields(ISC_PLUGIN_ID .'_options');
        do_settings_sections(ISC_PLUGIN_ID);        
        submit_button();
        echo '</form>'. ISC_PLUGIN_NAME . ' is powered by <a href="http://www.ispeech.org">iSpeech</a>. For help contact: <a href="mailto:support@ispeech.org?subject=Wordpress+Listen+Button">support@ispeech.org</a></div>';        
   }
}
if(is_admin())
{
    add_action('admin_init',array(ISC_PLUGIN_ID,"admin_init"));
    add_action('admin_menu',array(ISC_PLUGIN_ID,"admin_menu"));    
}
if(function_exists('add_action'))
{
    add_filter("the_content",array(ISC_PLUGIN_ID,"addbutton"),-100); 
    add_filter("the_title",array(ISC_PLUGIN_ID,"title"),-100,2); 
}   
endif;