/*
 * Decompiled with CFR 0.152.
 */
package com.iSpeech;

import com.iSpeech.ApiException;
import com.iSpeech.InvalidApiKeyException;
import com.iSpeech.TTSResult;
import com.iSpeech.iSpeechUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Hashtable;

public class iSpeechSynthesis {
    private static iSpeechSynthesis _iSpeech;
    private static String _apiKey;
    private static String API_URL;
    private String _voiceValue = null;
    private Hashtable<String, String> optionalParameters;

    private iSpeechSynthesis(String api, boolean production) throws InvalidApiKeyException {
        if (api == null || api.length() != 32) {
            throw new InvalidApiKeyException();
        }
        _apiKey = api;
        iSpeechSynthesis.setUp(production);
    }

    private static void setUp(boolean production) {
        API_URL = production ? "http://tts.ispeech.org/api/rest" : "http://dev.ispeech.org/api/rest";
    }

    public static iSpeechSynthesis getInstance(String apiKey, boolean production) throws InvalidApiKeyException {
        if (_iSpeech == null) {
            _iSpeech = new iSpeechSynthesis(apiKey, production);
        }
        return _iSpeech;
    }

    public void setVoice(String voice) {
        this._voiceValue = voice;
    }

    public void setOptionalCommand(String command, String parameter) {
        if (this.optionalParameters == null) {
            this.optionalParameters = new Hashtable();
        }
        this.optionalParameters.put(command, parameter);
    }

    public void clearMetaAndOptionalCommands() {
        this.optionalParameters = new Hashtable();
    }

    public TTSResult speak(String text) throws IOException, ApiException {
        if (text == null || text.length() == 0) {
            throw new IOException("Invalid Text");
        }
        text = URLEncoder.encode(text, "UTF-8");
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(String.valueOf(API_URL) + "?");
        urlBuilder.append("apikey=" + _apiKey);
        urlBuilder.append("&action=convert&text=" + text);
        if (this._voiceValue != null) {
            urlBuilder.append("&voice=" + this._voiceValue);
        }
        urlBuilder.append(iSpeechUtils.hashToString(this.optionalParameters));
        URL url = new URL(urlBuilder.toString());
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setDoInput(true);
        int l = Integer.valueOf(conn.getHeaderField("Content-Length"));
        if (conn.getResponseCode() != 200) {
            throw new ApiException(iSpeechUtils.getResult(conn.getInputStream(), l));
        }
        return new TTSResult(new DataInputStream(conn.getInputStream()), l);
    }
}

