/*
 * Decompiled with CFR 0.152.
 */
package com.iSpeech;

import com.iSpeech.ASRStreamer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class StreamingOutputStream
extends OutputStream {
    private ASRStreamer _outputStream;
    private ByteArrayOutputStream _in = new ByteArrayOutputStream();
    private Object syncObject = new Object();

    public StreamingOutputStream(ASRStreamer output) {
        this._outputStream = output;
    }

    @Override
    public void flush() throws IOException {
        if (this._outputStream.isReady) {
            this._outputStream.send(this._in.toByteArray());
            this._in.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int data) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this._in.write(data);
            if (this._in.size() > 2048) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this._in.write(b, off, len);
            if (this._in.size() >= 2048) {
                this.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b) throws IOException {
        Object object = this.syncObject;
        synchronized (object) {
            this._in.write(b);
            if (this._in.size() > 2048) {
                this.flush();
            }
        }
    }
}

