/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech.tools;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.ispeech.FreeformType;
import org.ispeech.SpeechRecognizer;
import org.ispeech.SpeechRecognizerEvent;
import org.ispeech.SpeechResult;
import org.ispeech.error.InvalidApiKeyException;
import org.ispeech.tools.Base64Coder;
import org.ispeech.tools.CommandResult;
import org.ispeech.tools.SerializableHashTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static String TAG = "iSpeech SDK" + Utilities.class.getSimpleName();
    public static final boolean APIKEY_GOOD = false;

    public static CommandResult cleanData(String data) throws IOException {
        byte[] b = Utilities.decodeBase64(Utilities.sevenToEight(Utilities.decodeBase64(data)).getBytes());
        DataInputStream bis = new DataInputStream(new ByteArrayInputStream(b));
        short packetLength = bis.readShort();
        if (packetLength == b.length - 2) {
            byte commandId = bis.readByte();
            short dataLength = bis.readShort();
            byte[] buffer = new byte[dataLength];
            bis.read(buffer, 0, dataLength);
            CommandResult c = new CommandResult(CommandResult.CommandType.parseInt(commandId), buffer);
            int paramCount = bis.readByte();
            int x = 0;
            while (x < paramCount) {
                short paramLength = bis.readShort();
                byte[] paramBuffer = new byte[paramLength];
                bis.read(paramBuffer, 0, paramLength);
                c.addParameter(paramBuffer);
                ++x;
            }
            byte uLength = bis.readByte();
            byte[] uBuffer = new byte[uLength];
            bis.read(uBuffer, 0, uLength);
            c.setUniqueId(new String(uBuffer, "utf8"));
            return c;
        }
        return null;
    }

    public static boolean isNetworkAvailable(Context context) {
        NetworkInfo[] info;
        ConnectivityManager connectivity = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivity != null && (info = connectivity.getAllNetworkInfo()) != null) {
            int i = 0;
            while (i < info.length) {
                if (info[i].getState() == NetworkInfo.State.CONNECTED) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static SerializableHashTable getResult(InputStream i, int l) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while (baos.size() < l) {
            byte[] b = new byte[2048];
            int read = i.read(b);
            baos.write(b, 0, read);
        }
        return SerializableHashTable.deserialize(baos.toByteArray());
    }

    public static byte[] decodeBase64(byte[] data) throws IOException {
        return Utilities.decodeBase64(new String(data));
    }

    public static byte[] decodeBase64(String text) throws IOException {
        return Base64Coder.decode(text);
    }

    public static char[] encodeBase64(byte[] data) throws IOException {
        return Base64Coder.encode(data);
    }

    private static byte[] ArraysCopy(byte[] b, int start, int count) {
        byte[] c = new byte[count];
        int i = start;
        while (i < count + start) {
            c[i - start] = b[i];
            ++i;
        }
        return c;
    }

    public static String sevenToEight(byte[] bytes) throws IOException {
        ByteArrayOutputStream ms = new ByteArrayOutputStream();
        int x = 0;
        while (x < bytes.length) {
            byte[] eightBytes = new byte[8];
            int i = Math.min(7, bytes.length - x);
            byte[] sevenBytes = Utilities.ArraysCopy(bytes, x, i);
            int y = 0;
            while (y < 8) {
                if (y < sevenBytes.length) {
                    eightBytes[7 - y] = sevenBytes[y];
                }
                ++y;
            }
            long d = new DataInputStream(new ByteArrayInputStream(eightBytes)).readLong();
            int y2 = 0;
            while (y2 <= i) {
                ms.write((byte)(d >> 7 * y2 & 0x7FL));
                ++y2;
            }
            x += 7;
        }
        return new String(ms.toByteArray(), "utf8").trim();
    }

    public static final byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >>> 24), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    public static String getNetworkName(Context context) {
        try {
            return ((TelephonyManager)context.getSystemService("phone")).getNetworkOperatorName();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getNetworkType(Context context) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            int type = tm.getNetworkType();
            switch (type) {
                case 4: {
                    return "CDMA";
                }
                case 1: {
                    return "GPRS";
                }
                case 3: {
                    return "UMTS";
                }
                case 7: {
                    return "1xRTT";
                }
                case 2: {
                    return "EDGE";
                }
                case 5: {
                    return "EVDO_0";
                }
                case 6: {
                    return "EVDO_A";
                }
            }
            return "UNKNOWN";
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getMCC(Context context) {
        try {
            String operator = ((TelephonyManager)context.getSystemService("phone")).getNetworkOperator();
            String mcc = null;
            if (operator != null && operator.length() != 0) {
                mcc = operator.substring(0, 3);
            }
            return mcc;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static float dp2px(float dp, Context context) {
        return dp * context.getResources().getDisplayMetrics().density + 0.5f;
    }

    public static String getMNC(Context context) {
        try {
            String operator = ((TelephonyManager)context.getSystemService("phone")).getNetworkOperator();
            String mnc = null;
            if (operator != null && operator.length() != 0) {
                mnc = operator.substring(3);
            }
            return mnc;
        }
        catch (Exception e) {
            return "";
        }
    }

    public static SerializableHashTable getMetaInfo(Context context) {
        SerializableHashTable meta = new SerializableHashTable();
        meta.put("networkType", Utilities.getNetworkType(context));
        meta.put("MCC", Utilities.getMCC(context));
        meta.put("MNC", Utilities.getMNC(context));
        meta.put("networkName", Utilities.getNetworkName(context));
        meta.put("sdkVersion", "1.0.0");
        meta.put("deviceType", "Android");
        return meta;
    }

    public static HttpResponse createConnection(String url, List<NameValuePair> post, int connectionTimeout) throws IOException {
        BasicHttpParams p = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)p, (int)connectionTimeout);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost c = new HttpPost(url);
        UrlEncodedFormEntity e = new UrlEncodedFormEntity(post);
        e.setContentType("application/x-www-form-urlencoded");
        c.setEntity((HttpEntity)e);
        return client.execute((HttpUriRequest)c);
    }

    public static void processCommand(final Context context, final CommandResult r, String apiKey, final int connectionTimeout) throws InvalidApiKeyException {
        if (r != null && !r.Command.equals((Object)CommandResult.CommandType.UNKNOWN)) {
            final Hashtable<String, String> commandList = new Hashtable<String, String>();
            if (r.getParameterCount() == 1) {
                switch (r.Command) {
                    case COMMAND_SEND_SMS: {
                        Utilities.sendSMS(context, r.getParameter(0), new String(r.Data));
                        break;
                    }
                    case COMMAND_PHONE_CALL: {
                        Utilities.initiateCall(context, r.getParameter(0));
                        break;
                    }
                    case COMMAND_LAUNCH_URL: {
                        Utilities.launchBrowser(context, r.getParameter(0));
                    }
                }
            } else {
                SpeechRecognizer sr = SpeechRecognizer.getInstance(context);
                sr.setFreeForm(FreeformType.FREEFORM_DISABLED);
                int i = 0;
                while (i < r.getParameterCount() - r.getParameterCount() % 2) {
                    sr.addCommand(new String[]{r.getParameter(i)});
                    commandList.put(r.getParameter(i).toLowerCase(), r.getParameter(i + 1));
                    i += 2;
                }
                if (r.getParameterCount() % 2 == 1) {
                    sr.addCommand(new String[]{r.getParameter(r.getParameterCount() - 1)});
                }
                try {
                    sr.startRecord(new SpeechRecognizerEvent(){

                        public void onRecordingComplete() {
                        }

                        public void onRecognitionComplete(SpeechResult result) {
                            if (result != null && result.getText() != null && result.getText().trim().length() > 0 && result.getConfidence() > 0.0f && (r.getParameterCount() % 2 != 0 || commandList.containsKey(result.getText().toLowerCase())) && !r.getParameter(r.getParameterCount() - 1).toLowerCase().equals(result.getText().toLowerCase()) && commandList != null && commandList.containsKey(result.getText().toLowerCase())) {
                                switch (r.Command) {
                                    case COMMAND_SEND_SMS: {
                                        Utilities.sendSMS(context, ((String)commandList.get(result.getText().toLowerCase())).toString(), new String(r.Data));
                                        break;
                                    }
                                    case COMMAND_PHONE_CALL: {
                                        Utilities.initiateCall(context, ((String)commandList.get(result.getText().toLowerCase())).toString());
                                        break;
                                    }
                                    case COMMAND_LAUNCH_URL: {
                                        Utilities.launchBrowser(context, ((String)commandList.get(result.getText().toLowerCase())).toString());
                                    }
                                }
                            }
                            ArrayList<NameValuePair> p = new ArrayList<NameValuePair>();
                            p.add((NameValuePair)new BasicNameValuePair("u", r.uniqueId));
                            p.add((NameValuePair)new BasicNameValuePair("s", "0"));
                            try {
                                Utilities.createConnection("https://api.ispeech.org/a/n", p, connectionTimeout);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }

                        public void onRecordingCancelled() {
                        }

                        public void onError(Exception exception) {
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void launchBrowser(Context context, String url) {
        Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        i.setFlags(0x10000000);
        context.startActivity(i);
    }

    private static void initiateCall(final Context context, final String phoneNum) {
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            public void run() {
                Intent callIntent = new Intent("android.intent.action.CALL");
                callIntent.setData(Uri.parse((String)("tel:" + phoneNum)));
                callIntent.setFlags(0x10000000);
                context.startActivity(callIntent);
            }
        }, 1000L);
    }

    private static void sendSMS(Context context, String phoneNum, String message) {
        SmsManager sms = SmsManager.getDefault();
        sms.sendTextMessage(phoneNum, null, message, null, null);
    }

    public static File loadFileFromPackage(Context c, String path, String name) throws IOException {
        InputStream stream = Utilities.class.getClassLoader().getResourceAsStream(path);
        File privateFile = new File(c.getFilesDir(), name);
        if (!privateFile.exists() && !privateFile.isFile() && stream != null) {
            int numread;
            FileOutputStream out1 = c.openFileOutput(name, 0);
            byte[] buf = new byte[16384];
            while ((numread = stream.read(buf)) > 0) {
                out1.write(buf, 0, numread);
            }
            stream.close();
            out1.close();
        }
        return privateFile;
    }

    public static String getApiKey(Context context) {
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            try {
                return ai.metaData.getString("ispeech_api_key");
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    public static boolean isDebug(Context context) {
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            boolean debug = ai.metaData.getBoolean("debug");
            return debug;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }
}

