/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech.tools;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.util.EntityUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpUtils {
    private static final String TAG = "HttpUtils";

    public static String addParamsToUrl(String url, List<NameValuePair> params) {
        StringBuffer buff = new StringBuffer(url);
        for (NameValuePair pair : params) {
            try {
                buff.append("&" + URLEncoder.encode(pair.getName(), "utf-8") + "=" + URLEncoder.encode(pair.getValue(), "utf-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return buff.toString().replaceFirst("&", "?");
    }

    public static Map<String, String> parseNameValuePairEntity(HttpEntity entity) throws IOException {
        String content = EntityUtils.toString((HttpEntity)entity);
        return HttpUtils.parseNameValuePairString(content);
    }

    public static Map<String, String> parseNameValuePairString(String content) throws IOException {
        String[] pairs;
        content = content.replaceAll("\\p{Cntrl}", "");
        HashMap<String, String> results = new HashMap<String, String>();
        String[] stringArray = pairs = content.split("&");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            String[] items = pair.split("=");
            results.put(items[0], items.length == 1 ? "" : URLDecoder.decode(items[1]));
            ++n2;
        }
        return results;
    }
}

