/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech.tools;

public class Base64Coder {
    private static final String systemLineSeparator = System.getProperty("line.separator");
    private static char[] map1 = new char[64];
    private static byte[] map2;

    static {
        int i = 0;
        int c = 65;
        while (c <= 90) {
            Base64Coder.map1[i++] = c;
            c = (char)(c + 1);
        }
        c = 97;
        while (c <= 122) {
            Base64Coder.map1[i++] = c;
            c = (char)(c + 1);
        }
        c = 48;
        while (c <= 57) {
            Base64Coder.map1[i++] = c;
            c = (char)(c + 1);
        }
        Base64Coder.map1[i++] = 43;
        Base64Coder.map1[i++] = 47;
        map2 = new byte[128];
        i = 0;
        while (i < map2.length) {
            Base64Coder.map2[i] = -1;
            ++i;
        }
        i = 0;
        while (i < 64) {
            Base64Coder.map2[Base64Coder.map1[i]] = (byte)i;
            ++i;
        }
    }

    public static String encodeString(String s) {
        return new String(Base64Coder.encode(s.getBytes()));
    }

    public static String encodeLines(byte[] in) {
        return Base64Coder.encodeLines(in, 0, in.length, 76, systemLineSeparator);
    }

    public static String encodeLines(byte[] in, int iOff, int iLen, int lineLen, String lineSeparator) {
        int blockLen = lineLen * 3 / 4;
        if (blockLen <= 0) {
            throw new IllegalArgumentException();
        }
        int lines = (iLen + blockLen - 1) / blockLen;
        int bufLen = (iLen + 2) / 3 * 4 + lines * lineSeparator.length();
        StringBuffer buf = new StringBuffer(bufLen);
        int ip = 0;
        while (ip < iLen) {
            int l = Math.min(iLen - ip, blockLen);
            buf.append(Base64Coder.encode(in, iOff + ip, l));
            buf.append(lineSeparator);
            ip += l;
        }
        return buf.toString();
    }

    public static char[] encode(byte[] in) {
        return Base64Coder.encode(in, 0, in.length);
    }

    public static char[] encode(byte[] in, int iLen) {
        return Base64Coder.encode(in, 0, iLen);
    }

    public static char[] encode(byte[] in, int iOff, int iLen) {
        int oDataLen = (iLen * 4 + 2) / 3;
        int oLen = (iLen + 2) / 3 * 4;
        char[] out = new char[oLen];
        int ip = iOff;
        int iEnd = iOff + iLen;
        int op = 0;
        while (ip < iEnd) {
            int i0 = in[ip++] & 0xFF;
            int i1 = ip < iEnd ? in[ip++] & 0xFF : 0;
            int i2 = ip < iEnd ? in[ip++] & 0xFF : 0;
            int o0 = i0 >>> 2;
            int o1 = (i0 & 3) << 4 | i1 >>> 4;
            int o2 = (i1 & 0xF) << 2 | i2 >>> 6;
            int o3 = i2 & 0x3F;
            out[op++] = map1[o0];
            out[op++] = map1[o1];
            out[op] = op < oDataLen ? map1[o2] : 61;
            int n = ++op < oDataLen ? map1[o3] : 61;
            out[op] = n;
            ++op;
        }
        return out;
    }

    public static String decodeString(String s) {
        return new String(Base64Coder.decode(s));
    }

    public static byte[] decodeLines(String s) {
        char[] buf = new char[s.length()];
        int p = 0;
        int ip = 0;
        while (ip < s.length()) {
            char c = s.charAt(ip);
            if (c != ' ' && c != '\r' && c != '\n' && c != '\t') {
                buf[p++] = c;
            }
            ++ip;
        }
        return Base64Coder.decode(buf, 0, p);
    }

    public static byte[] decode(String s) {
        return Base64Coder.decode(s.toCharArray());
    }

    public static byte[] decode(char[] in) {
        return Base64Coder.decode(in, 0, in.length);
    }

    /*
     * Unable to fully structure code
     */
    public static byte[] decode(char[] in, int iOff, int iLen) {
        if (iLen % 4 == 0) ** GOTO lbl4
        throw new IllegalArgumentException("Length of Base64 encoded input string is not a multiple of 4.");
lbl-1000:
        // 1 sources

        {
            --iLen;
lbl4:
            // 2 sources

            ** while (iLen > 0 && in[iOff + iLen - 1] == '=')
        }
lbl5:
        // 1 sources

        oLen = iLen * 3 / 4;
        out = new byte[oLen];
        ip = iOff;
        iEnd = iOff + iLen;
        op = 0;
        while (ip < iEnd) {
            i0 = in[ip++];
            i1 = in[ip++];
            i2 = ip < iEnd ? in[ip++] : 65;
            v0 = i3 = ip < iEnd ? in[ip++] : 65;
            if (i0 > '\u007f' || i1 > '\u007f' || i2 > 127 || i3 > 127) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            b0 = Base64Coder.map2[i0];
            b1 = Base64Coder.map2[i1];
            b2 = Base64Coder.map2[i2];
            b3 = Base64Coder.map2[i3];
            if (b0 < 0 || b1 < 0 || b2 < 0 || b3 < 0) {
                throw new IllegalArgumentException("Illegal character in Base64 encoded data.");
            }
            o0 = b0 << 2 | b1 >>> 4;
            o1 = (b1 & 15) << 4 | b2 >>> 2;
            o2 = (b2 & 3) << 6 | b3;
            out[op++] = (byte)o0;
            if (op < oLen) {
                out[op++] = (byte)o1;
            }
            if (op >= oLen) continue;
            out[op++] = (byte)o2;
        }
        return out;
    }

    private Base64Coder() {
    }
}

