/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.view.View;
import org.ispeech.MProcessingDialog;
import org.ispeech.core.ImageScreen;
import org.ispeech.core.RecognizerDialog;
import org.ispeech.core.SynthesisDialog;

public final class iSpeechFramework
extends FragmentActivity {
    private static final String TAG = "iSpeech SDK";
    public static final int CHECK_ID = -1;
    static final int DIALOG_ID_RECOGNIZER = 0;
    static final int DIALOG_ID_ADVERTISEMENT = 1;
    public static final int DIALOG_ID_SYNTHESIS = 2;
    static final int DIALOG_ID_LOADING = 3;
    Handler dialogMessageHandler;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.dialogMessageHandler = new Handler(){

            public void handleMessage(Message msg) {
                iSpeechFramework.this.showDialog(msg.what);
            }
        };
        Intent intent = this.getIntent();
        int id = intent.getExtras().getInt("type");
        if (id == -1) {
            this.finish();
        } else if (id == 0) {
            FragmentManager fm = this.getSupportFragmentManager();
            RecognizerDialog.getInstance().show(fm, "fragment_recognizer_dialog");
        } else {
            this.showDialog(id);
        }
    }

    protected Dialog onCreateDialog(int id) {
        Dialog dialog = null;
        switch (id) {
            case 1: {
                Intent intent = this.getIntent();
                String iu = intent.getExtras().getString("iu");
                String cu = intent.getExtras().getString("cu");
                int h = intent.getExtras().getInt("h");
                int w = intent.getExtras().getInt("w");
                ImageScreen screen = new ImageScreen((Context)this, iu, cu, w, h);
                dialog = screen;
                break;
            }
            case 2: {
                SynthesisDialog d = SynthesisDialog.newInstance((Context)this);
                d.setOnCancelClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        SynthesisDialog.getInstance().dismiss();
                    }
                });
                dialog = d;
                break;
            }
            case 3: {
                dialog = new MProcessingDialog((Activity)this);
                break;
            }
            default: {
                dialog = null;
            }
        }
        if (dialog != null) {
            dialog.setOwnerActivity((Activity)this);
        }
        return dialog;
    }
}

