/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech.core;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.ispeech.core.InternalResources;
import org.ispeech.tools.HttpUtils;
import org.ispeech.tools.SerializableHashTable;
import org.ispeech.tools.Utilities;

public class TTSEngine {
    protected static final String TAG = "iSpeech SDK";
    private String apikey;
    private String url;
    private static MediaPlayer mediaPlayer;
    private boolean isRunning;
    private String voiceType;
    private int streamType = InternalResources.STREAM_TYPE;
    public boolean startedSpeaking = false;
    private boolean changeVolume = false;
    private boolean earlyStop = false;
    private int originalVolume;
    private static volatile TTSEngine _instance;
    private ResponseHandler handler;
    private String audioFile = "ispeechtts.mp3";
    private SerializableHashTable meta = new SerializableHashTable();
    private Map<String, String> optional = new HashMap<String, String>();
    private int socketTimeout = 60000;

    public static TTSEngine getInstance(String url, String apikey) {
        if (_instance == null) {
            _instance = new TTSEngine(url, apikey);
        }
        if (mediaPlayer == null) {
            mediaPlayer = new MediaPlayer();
        }
        return _instance;
    }

    public void setVoice(String voice) {
        this.voiceType = voice;
    }

    public void setAudioStreamType(int streamtype) {
        this.streamType = streamtype;
    }

    public void setMeta(SerializableHashTable m) {
        this.meta = m;
    }

    public void addMeta(String key, String value) {
        this.meta.put(key, value);
    }

    public void setResponseHandler(ResponseHandler handler) {
        this.handler = handler;
    }

    private TTSEngine(String url, String apikey) {
        this.apikey = apikey;
        this.url = url;
    }

    public void setOnCompletionListener(MediaPlayer.OnCompletionListener listener) {
        mediaPlayer.setOnCompletionListener(listener);
    }

    public void setOnPreparedListener(MediaPlayer.OnPreparedListener listener) {
        mediaPlayer.setOnPreparedListener(listener);
    }

    public int getPosition() {
        return mediaPlayer.getCurrentPosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSpeaking() {
        TTSEngine tTSEngine = _instance;
        synchronized (tTSEngine) {
            if (mediaPlayer != null) {
                return mediaPlayer.isPlaying() || this.startedSpeaking;
            }
            return false;
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        TTSEngine tTSEngine = _instance;
        synchronized (tTSEngine) {
            if (mediaPlayer.isPlaying()) {
                mediaPlayer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        TTSEngine tTSEngine = _instance;
        synchronized (tTSEngine) {
            if (!mediaPlayer.isPlaying()) {
                mediaPlayer.release();
                mediaPlayer = new MediaPlayer();
            }
            this.isRunning = false;
        }
    }

    public void setEarlyStop() {
        this.earlyStop = true;
    }

    public byte[] downloadByteArray(Context context, String text) throws IOException {
        CopyOnWriteArrayList<NameValuePair> nameValuePairs = new CopyOnWriteArrayList<NameValuePair>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("apikey", this.apikey));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("text", text));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("deviceType", "android"));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("action", "convert"));
        if (this.voiceType != null) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("voice", this.voiceType));
        }
        if (this.meta != null) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("meta", new String(Utilities.encodeBase64(this.meta.serialize()))));
        }
        if (this.optional != null && this.optional.size() > 0) {
            for (String command : this.optional.keySet()) {
                nameValuePairs.add((NameValuePair)new BasicNameValuePair(command, this.optional.get(command)));
            }
        }
        String urlStr = HttpUtils.addParamsToUrl(this.url, nameValuePairs);
        DefaultHttpClient client = new DefaultHttpClient();
        client.getParams().setParameter("http.socket.timeout", (Object)new Integer(this.socketTimeout));
        HttpResponse response = client.execute((HttpUriRequest)new HttpGet(urlStr));
        if (this.handler != null) {
            this.handler.onResponse(response);
        }
        if (response.getEntity().getContentType().getValue().contains("audio")) {
            FileOutputStream out1 = context.openFileOutput(this.audioFile, 0);
            response.getEntity().writeTo((OutputStream)out1);
            out1.close();
            File privateFile = new File(String.valueOf(context.getFilesDir().getAbsolutePath()) + "/" + this.audioFile);
            FileInputStream localFileInputStream = new FileInputStream(privateFile);
            byte[] b = new byte[(int)privateFile.length()];
            localFileInputStream.read(b);
            return b;
        }
        byte[] nb = null;
        return nb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void speak(Context context, String text) throws IOException {
        block20: {
            this.isRunning = true;
            final AudioManager mAudioManager = (AudioManager)context.getSystemService("audio");
            int streamVolumeCurrent = mAudioManager.getStreamVolume(InternalResources.STREAM_TYPE);
            if (InternalResources.ALWAYS_SPEAK && streamVolumeCurrent <= 0) {
                this.changeVolume = true;
                mAudioManager.setRingerMode(2);
                this.originalVolume = mAudioManager.getStreamVolume(InternalResources.STREAM_TYPE);
                int maxVolume = mAudioManager.getStreamMaxVolume(InternalResources.STREAM_TYPE);
                mAudioManager.setStreamVolume(InternalResources.STREAM_TYPE, maxVolume / 2, 1);
            }
            try {
                try {
                    CopyOnWriteArrayList<NameValuePair> nameValuePairs = new CopyOnWriteArrayList<NameValuePair>();
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("apikey", this.apikey));
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("text", text));
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("deviceType", "android"));
                    nameValuePairs.add((NameValuePair)new BasicNameValuePair("action", "convert"));
                    if (this.voiceType != null) {
                        nameValuePairs.add((NameValuePair)new BasicNameValuePair("voice", this.voiceType));
                    }
                    if (this.meta != null) {
                        nameValuePairs.add((NameValuePair)new BasicNameValuePair("meta", new String(Utilities.encodeBase64(this.meta.serialize()))));
                    }
                    if (this.optional != null && this.optional.size() > 0) {
                        for (String command : this.optional.keySet()) {
                            nameValuePairs.add((NameValuePair)new BasicNameValuePair(command, this.optional.get(command)));
                        }
                    }
                    String urlStr = HttpUtils.addParamsToUrl(this.url, nameValuePairs);
                    DefaultHttpClient client = new DefaultHttpClient();
                    client.getParams().setParameter("http.socket.timeout", (Object)new Integer(this.socketTimeout));
                    HttpResponse response = client.execute((HttpUriRequest)new HttpGet(urlStr));
                    if (this.handler != null) {
                        this.handler.onResponse(response);
                    }
                    if (!response.getEntity().getContentType().getValue().contains("audio")) break block20;
                    FileOutputStream out1 = context.openFileOutput(this.audioFile, 0);
                    response.getEntity().writeTo((OutputStream)out1);
                    out1.close();
                    File privateFile = new File(String.valueOf(context.getFilesDir().getAbsolutePath()) + "/" + this.audioFile);
                    try {
                        TTSEngine tTSEngine = _instance;
                        synchronized (tTSEngine) {
                            if (!mediaPlayer.isPlaying()) {
                                mediaPlayer.reset();
                                FileInputStream localFileInputStream = new FileInputStream(privateFile);
                                mediaPlayer.setDataSource(localFileInputStream.getFD());
                                mediaPlayer.setAudioStreamType(this.streamType);
                                mediaPlayer.prepare();
                                localFileInputStream.close();
                            }
                        }
                        Thread.sleep(100L);
                        this.startedSpeaking = true;
                        mediaPlayer.start();
                        if (this.changeVolume) {
                            new Thread(new Runnable(){

                                public void run() {
                                    while (TTSEngine.this.startedSpeaking) {
                                        try {
                                            Thread.sleep(1000L);
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    TTSEngine.this.earlyStop = false;
                                    mAudioManager.setStreamVolume(InternalResources.STREAM_TYPE, TTSEngine.this.originalVolume, 1);
                                    TTSEngine.this.changeVolume = false;
                                }
                            }).start();
                        }
                    }
                    catch (IOException iOException) {
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (IllegalStateException illegalStateException) {
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.isRunning = false;
                }
            }
            finally {
                this.isRunning = false;
            }
        }
    }

    public void setOnErrorListener(MediaPlayer.OnErrorListener onError) {
        mediaPlayer.setOnErrorListener(onError);
    }

    public int getCurrentPosition() {
        return mediaPlayer.getCurrentPosition();
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void addOptionalCommand(String command, String parameter) {
        this.optional.put(command, parameter);
    }

    public void clearOptionalCommand() {
        this.optional.clear();
    }

    public void cancelTTS() {
        mediaPlayer.stop();
    }

    public static interface ResponseHandler {
        public void onResponse(HttpResponse var1);
    }
}

