/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech.core;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TableLayout;
import android.widget.TextView;
import java.io.InputStream;

public class SynthesisDialog
extends Dialog {
    Context context;
    private Button stop;
    private Button cancel;
    private ImageView animation;
    private ImageView title;
    private TextView text;
    private AnimationDrawable animationDrawable;
    private static Bitmap[] animationFrames;
    private static Bitmap logo;
    private static final int animationMaxLevel = 4;
    private final float scale;
    private static SynthesisDialog instance;
    Handler startAnimation = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            AnimationDrawable rocketAnimation = (AnimationDrawable)SynthesisDialog.this.animation.getBackground();
            rocketAnimation.start();
        }
    };

    static {
        instance = null;
    }

    public static SynthesisDialog getInstance() {
        return instance;
    }

    public static SynthesisDialog newInstance(Context context) {
        instance = new SynthesisDialog(context);
        return instance;
    }

    private float dp2px(float dp) {
        return dp * this.scale + 0.5f;
    }

    public SynthesisDialog(Context context) {
        super(context);
        this.requestWindowFeature(1);
        this.setCancelable(false);
        this.context = context;
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        this.scale = metrics.density;
        if (logo == null) {
            logo = BitmapFactory.decodeStream((InputStream)SynthesisDialog.class.getClassLoader().getResourceAsStream("org/ispeech/raw/logo.png"));
            int width = (int)this.dp2px(44.0f);
            int height = (int)this.dp2px(18.0f);
            logo = Bitmap.createScaledBitmap((Bitmap)logo, (int)width, (int)height, (boolean)true);
        }
        this.animationDrawable = new AnimationDrawable();
        this.animationDrawable.setOneShot(false);
        if (animationFrames == null) {
            animationFrames = new Bitmap[5];
            int i = 0;
            while (i <= 4) {
                SynthesisDialog.animationFrames[i] = BitmapFactory.decodeStream((InputStream)SynthesisDialog.class.getClassLoader().getResourceAsStream("org/ispeech/raw/mic_" + i + ".png"));
                int width = (int)this.dp2px(32.0f);
                int height = (int)this.dp2px(64.0f);
                SynthesisDialog.animationFrames[i] = Bitmap.createScaledBitmap((Bitmap)animationFrames[i], (int)width, (int)height, (boolean)true);
                this.animationDrawable.addFrame((Drawable)new BitmapDrawable(animationFrames[i]), 500);
                ++i;
            }
        }
        this.initLayout();
    }

    public void setOnStopClickListener(View.OnClickListener l) {
        this.stop.setOnClickListener(l);
    }

    public void setOnCancelClickListener(View.OnClickListener l) {
        this.cancel.setOnClickListener(l);
    }

    private void initLayout() {
        GradientDrawable titleBg = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{-14540254, -7829368});
        titleBg.setCornerRadii(new float[]{5.0f, 5.0f, 5.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f});
        this.title = new ImageView(this.context);
        this.title.setImageBitmap(logo);
        this.title.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        LinearLayout titleWrapper = new LinearLayout(this.context);
        titleWrapper.setGravity(17);
        LinearLayout.LayoutParams lo = new LinearLayout.LayoutParams(-1, -2);
        titleWrapper.setPadding(0, (int)this.dp2px(2.0f), 0, (int)this.dp2px(2.0f));
        titleWrapper.setBackgroundDrawable((Drawable)titleBg);
        titleWrapper.setLayoutParams((ViewGroup.LayoutParams)lo);
        titleWrapper.addView((View)this.title);
        this.stop = new Button(this.context);
        this.stop.setText((CharSequence)"Stop");
        this.cancel = new Button(this.context);
        this.cancel.setText((CharSequence)"Cancel");
        this.animation = new ImageView(this.context);
        this.animation.setBackgroundDrawable((Drawable)this.animationDrawable);
        this.animation.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        LinearLayout animWrapper = new LinearLayout(this.context);
        lo = new LinearLayout.LayoutParams(-2, -2);
        lo.setMargins(0, (int)this.dp2px(10.0f), 0, (int)this.dp2px(10.0f));
        animWrapper.setLayoutParams((ViewGroup.LayoutParams)lo);
        animWrapper.addView((View)this.animation);
        this.text = new TextView(this.context);
        this.text.setTextColor(-1);
        this.text.setTextSize(25.0f);
        this.text.setGravity(1);
        lo = new LinearLayout.LayoutParams(-2, -2);
        lo.setMargins((int)this.dp2px(20.0f), 0, (int)this.dp2px(20.0f), (int)this.dp2px(20.0f));
        this.text.setLayoutParams((ViewGroup.LayoutParams)lo);
        LinearLayout ll = new LinearLayout(this.context);
        lo = new LinearLayout.LayoutParams((int)this.dp2px(200.0f), -1);
        lo.setMargins((int)this.dp2px(50.0f), (int)this.dp2px(10.0f), (int)this.dp2px(50.0f), (int)this.dp2px(10.0f));
        ll.setLayoutParams((ViewGroup.LayoutParams)lo);
        ll.setGravity(17);
        ll.setOrientation(1);
        ll.addView((View)titleWrapper);
        ll.addView((View)animWrapper);
        ll.addView((View)this.text);
        LinearLayout child = new LinearLayout(this.context);
        child.setBackgroundColor(-7829368);
        child.setGravity(17);
        child.setLayoutParams((ViewGroup.LayoutParams)new TableLayout.LayoutParams(-1, -2));
        lo = new LinearLayout.LayoutParams(-1, -2, 0.5f);
        this.stop.setLayoutParams((ViewGroup.LayoutParams)lo);
        lo = new LinearLayout.LayoutParams(-1, -2, 0.5f);
        this.cancel.setLayoutParams((ViewGroup.LayoutParams)lo);
        child.addView((View)this.stop);
        child.addView((View)this.cancel);
        ll.addView((View)child);
        this.setContentView((View)ll);
    }

    public Button getCancel() {
        return this.cancel;
    }

    public void dismiss() {
        if (this.getOwnerActivity() != null) {
            this.getOwnerActivity().finish();
        }
        super.dismiss();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        AnimationDrawable rocketAnimation = (AnimationDrawable)this.animation.getBackground();
        rocketAnimation.start();
    }
}

