/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech.core;

import android.content.Context;
import android.media.AudioManager;
import android.media.SoundPool;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.ispeech.core.InternalResources;
import org.ispeech.tools.Utilities;

public class SoundBox {
    private static final String TAG = "SoundBox";
    private Context context;
    private SoundPool soundPool;
    private Map<Integer, Integer> soundPoolMap;
    private static SoundBox instance;

    public static SoundBox getInstance(Context context) {
        if (instance == null) {
            instance = new SoundBox(context);
        }
        return instance;
    }

    private SoundBox(Context context) {
        this.context = context;
        if (this.soundPool == null) {
            this.soundPool = new SoundPool(4, InternalResources.STREAM_TYPE, 100);
            try {
                File open = Utilities.loadFileFromPackage(context, "org/ispeech/raw/voice_open.mp3", "voice_open.mp3");
                File close = Utilities.loadFileFromPackage(context, "org/ispeech/raw/voice_close.mp3", "voice_close.mp3");
                this.soundPoolMap = new HashMap<Integer, Integer>();
                this.soundPoolMap.put(0, this.soundPool.load(close.getAbsolutePath(), 1));
                this.soundPoolMap.put(1, this.soundPool.load(open.getAbsolutePath(), 1));
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void playSound(int sound) {
        AudioManager mgr = (AudioManager)this.context.getSystemService("audio");
        float streamVolumeCurrent = mgr.getStreamVolume(InternalResources.STREAM_TYPE);
        float streamVolumeMax = mgr.getStreamMaxVolume(InternalResources.STREAM_TYPE);
        float volume = streamVolumeCurrent;
        volume = streamVolumeMax / 2.0f;
        this.soundPool.play(this.soundPoolMap.get(sound).intValue(), volume, volume, 1, 0, 1.0f);
    }

    public void playOpen() {
        this.playSound(1);
    }

    public void playClose() {
        this.playSound(0);
    }
}

