/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech.core;

import org.ispeech.core.SilenceResult;

public class SilenceDetection {
    private static final String TAG = "iSpeech SDK";
    private static int delta = 0;
    private static int energyMax = 0;
    private static int initialEnergy = 0;
    private static long threshold = 0L;
    private static boolean initialized = false;
    private static int relativeSilenceCounter = 0;
    private static int energyMaxCounter = 0;
    private static long energyMaxAverage = 0L;
    private static int counter = 0;
    private static boolean goingUp = true;

    public static SilenceResult checkSilence(byte[] data, int from, int length, long average, long minAverage) {
        long currEnergy = SilenceDetection.calcEnergy(data, from, length);
        if (!initialized) {
            delta = (int)((double)currEnergy * 0.25);
            threshold = currEnergy + (long)delta;
            initialized = true;
        } else if (minAverage < threshold && minAverage > 0L) {
            threshold = (long)Math.max((double)minAverage * 1.25, (double)energyMax * 0.15);
        }
        if (currEnergy > threshold) {
            return new SilenceResult(false, currEnergy, SilenceDetection.getNormalizedEnergy(currEnergy));
        }
        return new SilenceResult(true, currEnergy, 0);
    }

    public static int getEnergy(byte[] data) {
        return SilenceDetection.getNormalizedEnergy(SilenceDetection.calcEnergy(data, 0, data.length));
    }

    public static int getNormalizedEnergy(long currEnergy) {
        if (relativeSilenceCounter < 3) {
            initialEnergy = (int)(((long)(initialEnergy * relativeSilenceCounter) + currEnergy) / (long)(relativeSilenceCounter + 1));
            if (++relativeSilenceCounter == 3) {
                energyMaxAverage = initialEnergy * 5;
            }
            return 0;
        }
        float temp = (float)(currEnergy -= (long)initialEnergy) / (float)(energyMax - initialEnergy);
        return (int)Math.floor(temp *= 128.0f);
    }

    private static long calcEnergy(byte[] input, int from, int length) {
        long out = 0L;
        int n = 0;
        int i = from;
        while (i + 1 < from + length - 1) {
            int bb = input[i] & 0xFF;
            if ((bb += (input[i + 1] & 0xFF) * 256) > 32768) {
                bb = 65536 - bb;
            }
            out += (long)bb;
            ++n;
            i += 2;
        }
        return out /= (long)n;
    }
}

