/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech.core;

import DrawImage.DrawCanvas;
import android.app.Dialog;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import org.ispeech.SpeechRecognizer;
import org.ispeech.error.InvalidApiKeyException;
import org.ispeech.tools.Utilities;

public class RecognizerDialog
extends DialogFragment {
    private static final String TAG = "iSpeech SDK->" + RecognizerDialog.class.getSimpleName();
    public static final int DISMISS_DIALOG = 0;
    public static final int SHOW_DIALOG = 1;
    public static final int SET_PROCESSING = 2;
    public static final int UPDATE_MICROPHONE_LEVEL = 3;
    public static boolean dialogRunning = true;
    private static RecognizerDialog _instance;
    private MicDialog micDialog;
    private boolean drawStarted = false;

    public RecognizerDialog() {
        _instance = this;
        this.setRetainInstance(false);
    }

    public static RecognizerDialog getInstance() {
        if (_instance == null) {
            _instance = new RecognizerDialog();
        }
        return _instance;
    }

    public Dialog onCreateDialog(Bundle savedInstaceState) {
        this.micDialog = new MicDialog((Context)this.getActivity());
        if (this.drawStarted) {
            this.startDraw();
        }
        return this.micDialog;
    }

    public void clearLayout() {
        this.micDialog.clearLayout();
    }

    public void setRecognizing() {
        this.micDialog.setRecognizing();
    }

    public void startDraw() {
        if (this.micDialog == null) {
            this.drawStarted = true;
        } else {
            this.micDialog.startDraw();
        }
    }

    public boolean isDialogRunning() {
        return dialogRunning;
    }

    public void setMicrophoneLevel(int level) {
        if (this.micDialog != null) {
            this.micDialog.microphone.setY(level);
        }
    }

    public void fixCanvas() {
        if (this.getActivity() == null) {
            this.dismiss();
            return;
        }
        this.getActivity().runOnUiThread(new Runnable(){

            public void run() {
                ((RecognizerDialog)RecognizerDialog.this).micDialog.microphone.setBackgroundDrawable(null);
            }
        });
    }

    public void dismiss() {
        this.micDialog.dismiss();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    private class MicDialog
    extends Dialog {
        Context context;
        RelativeLayout parentView;
        DrawCanvas microphone;
        private Button stop;
        private Button cancel;

        public MicDialog(Context context) {
            super(context, 16973914);
            this.context = context;
            this.requestWindowFeature(1);
            this.setCancelable(false);
            this.initLayout();
        }

        private void initLayout() {
            GradientDrawable titleBg = new GradientDrawable(GradientDrawable.Orientation.BOTTOM_TOP, new int[]{-14540254, -7829368});
            titleBg.setCornerRadii(new float[]{5.0f, 5.0f, 5.0f, 5.0f, 0.0f, 0.0f, 0.0f, 0.0f});
            int width = (int)Utilities.dp2px(150.0f, this.context);
            RelativeLayout.LayoutParams parentViewLayoutParams = new RelativeLayout.LayoutParams(width, -1);
            parentViewLayoutParams.setMargins((int)Utilities.dp2px(50.0f, this.context), (int)Utilities.dp2px(10.0f, this.context), (int)Utilities.dp2px(50.0f, this.context), (int)Utilities.dp2px(10.0f, this.context));
            this.parentView = new RelativeLayout(this.context);
            this.parentView.setLayoutParams((ViewGroup.LayoutParams)parentViewLayoutParams);
            this.parentView.setGravity(17);
            this.microphone = new DrawCanvas(this.context, width);
            RelativeLayout.LayoutParams microphoneLayoutParams = new RelativeLayout.LayoutParams(width, -2);
            this.microphone.setId(1000);
            this.microphone.setLayoutParams((ViewGroup.LayoutParams)microphoneLayoutParams);
            this.parentView.addView((View)this.microphone);
            LinearLayout buttons = new LinearLayout(this.context);
            RelativeLayout.LayoutParams buttonsLayoutParams = new RelativeLayout.LayoutParams(width, -2);
            buttonsLayoutParams.addRule(3, this.microphone.getId());
            buttons.setLayoutParams((ViewGroup.LayoutParams)buttonsLayoutParams);
            buttons.setBackgroundColor(-7829368);
            buttons.setGravity(17);
            this.addCancelStopButtons(buttons);
            this.parentView.addView((View)buttons);
            this.setContentView((View)this.parentView);
            this.setRecording();
        }

        private void addCancelStopButtons(LinearLayout child) {
            this.stop = new Button(this.context);
            this.stop.setText((CharSequence)"Done");
            this.cancel = new Button(this.context);
            this.cancel.setText((CharSequence)"Cancel");
            this.stop.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        SpeechRecognizer.getInstance(MicDialog.this.context).stopRecord();
                    }
                    catch (InvalidApiKeyException invalidApiKeyException) {
                        // empty catch block
                    }
                }
            });
            this.cancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        SpeechRecognizer.getInstance(MicDialog.this.context).cancelRecord();
                    }
                    catch (InvalidApiKeyException invalidApiKeyException) {
                        // empty catch block
                    }
                    MicDialog.this.clearLayout();
                    MicDialog.this.dismiss();
                }
            });
            this.stop.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            this.cancel.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            child.addView((View)this.stop);
            child.addView((View)this.cancel);
        }

        public void clearLayout() {
            this.parentView.removeAllViews();
        }

        public void setRecording() {
            this.stop.setVisibility(0);
            this.cancel.setVisibility(0);
        }

        public void setRecognizing() {
            this.microphone.setProcessing();
            this.stop.setVisibility(8);
            this.cancel.setVisibility(0);
            this.cancel.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    try {
                        SpeechRecognizer.getInstance(MicDialog.this.context).cancelProcessing();
                    }
                    catch (InvalidApiKeyException invalidApiKeyException) {
                        // empty catch block
                    }
                    MicDialog.this.clearLayout();
                    MicDialog.this.dismiss();
                }
            });
        }

        public void startDraw() {
            this.microphone.startDrawImage();
        }

        public void dismiss() {
            super.dismiss();
            this.killActivity();
        }

        private void killActivity() {
            if (RecognizerDialog.this.getActivity() != null) {
                RecognizerDialog.this.getActivity().finish();
            }
            dialogRunning = false;
        }

        public void onBackPressed() {
            try {
                SpeechRecognizer.getInstance(this.context).cancelRecord();
            }
            catch (InvalidApiKeyException invalidApiKeyException) {
                // empty catch block
            }
            super.onBackPressed();
        }
    }
}

