/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech.core;

import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.Toast;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class ImageScreen
extends Dialog {
    private static final String TAG = "ImageScreen";
    private Thread downloadThread;
    private String url;
    private String curl;
    private Button btnDismiss;
    private ImageView imgBanner;
    private int imageWidth;
    private int imageHeight;
    private ProgressDialog pd;
    private Handler h;

    private void create(Context context) {
        LinearLayout ll = new LinearLayout(context);
        ll.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        ll.setGravity(1);
        ll.setOrientation(1);
        ll.setPadding(10, 10, 10, 10);
        ScrollView sv = new ScrollView(context);
        sv.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        ll.addView((View)this.imgBanner);
        ll.addView((View)this.btnDismiss);
        this.setTitle("Cali");
        sv.addView((View)ll);
        this.setContentView((View)sv);
        this.btnDismiss.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageScreen.this.dismiss();
            }
        });
        this.imgBanner.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageScreen.this.dismiss();
                ImageScreen.this.getContext().startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)ImageScreen.this.curl)));
            }
        });
    }

    public void dismiss() {
        if (this.getOwnerActivity() != null) {
            this.getOwnerActivity().finish();
        }
        super.dismiss();
    }

    public ImageScreen(final Context context, String u, String cu, int iW, int iH) {
        super(context, 16973830);
        this.btnDismiss = new Button(context);
        this.imgBanner = new ImageView(context);
        this.url = u;
        this.imageHeight = iH;
        this.imageWidth = iW;
        this.curl = cu;
        this.h = new Handler(context.getMainLooper()){

            public void handleMessage(Message msg) {
                if (msg.what == 0) {
                    ImageScreen.this.pd.dismiss();
                    ImageScreen.this.btnDismiss.setText((CharSequence)"Dismiss");
                    ImageScreen.this.imgBanner.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    Display w = ((WindowManager)ImageScreen.this.getContext().getSystemService("window")).getDefaultDisplay();
                    ImageScreen.this.imgBanner.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(Math.min(ImageScreen.this.imageWidth, w.getWidth()), Math.min(ImageScreen.this.imageHeight, w.getHeight() - 100)));
                    ImageScreen.this.create(context);
                    ImageScreen.this.show();
                } else if (msg.what == -1) {
                    ImageScreen.this.pd = ProgressDialog.show((Context)context, null, (CharSequence)"Please wait... ");
                    ImageScreen.this.pd.setCancelable(false);
                } else {
                    ImageScreen.this.pd.dismiss();
                    Toast.makeText((Context)ImageScreen.this.getContext(), (CharSequence)"Could not download image", (int)1).show();
                    ImageScreen.this.dismiss();
                }
            }
        };
        this.downloadThread = new Thread(){

            public void run() {
                ImageScreen.this.downloadImage();
            }
        };
        this.h.sendEmptyMessage(-1);
        this.downloadThread.start();
    }

    private void downloadImage() {
        try {
            DefaultHttpClient c = new DefaultHttpClient();
            HttpResponse response = c.execute((HttpUriRequest)new HttpGet(this.url));
            this.imgBanner.setImageDrawable(Drawable.createFromStream((InputStream)response.getEntity().getContent(), (String)this.url));
            if (this.imgBanner.getDrawable() != null) {
                this.h.sendEmptyMessage(0);
                return;
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.h.sendEmptyMessage(1);
    }
}

