/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech.core;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.ispeech.tools.HttpUtils;
import org.ispeech.tools.SerializableHashTable;
import org.ispeech.tools.Utilities;

public class ASREngine {
    private static final String TAG = ASREngine.class.getSimpleName();
    private String apikey;
    private String url;
    private String voiceType;
    private SerializableHashTable meta = new SerializableHashTable();
    private static volatile ASREngine instance;

    public static ASREngine getInstance(String url, String apikey) {
        if (instance == null) {
            instance = new ASREngine(url, apikey);
        }
        return instance;
    }

    private ASREngine(String url, String apikey) {
        this.apikey = apikey;
        this.url = url;
    }

    public void setVoice(String voice) {
        this.voiceType = voice;
    }

    public void addMeta(String key, String value) {
        this.meta.put(key, value);
    }

    public String recognize(byte[] audio, AudioType type) throws IOException {
        CopyOnWriteArrayList<NameValuePair> nameValuePairs = new CopyOnWriteArrayList<NameValuePair>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("apikey", this.apikey));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("content-type", type.getContentType()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("deviceType", "android"));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("action", "recognize"));
        if (this.voiceType != null) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("voice", this.voiceType));
        }
        if (this.meta != null) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("meta", new String(Utilities.encodeBase64(this.meta.serialize()))));
        }
        String urlStr = HttpUtils.addParamsToUrl(this.url, nameValuePairs);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(urlStr);
        post.setEntity((HttpEntity)new ByteArrayEntity(audio));
        HttpResponse response = client.execute((HttpUriRequest)post);
        Map<String, String> result = HttpUtils.parseNameValuePairEntity(response.getEntity());
        return result.get("result");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AudioType {
        AMR("audio/amr"),
        MPEG("audio/mpeg");

        private final String contentType;

        private AudioType(String type) {
            this.contentType = type;
        }

        public String getContentType() {
            return this.contentType;
        }
    }
}

