/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.ispeech.MouthMovements;
import org.ispeech.ParserCallback;
import org.ispeech.VisemeHolder;
import org.ispeech.VisemeSAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class VisemeConnection
extends Thread
implements ParserCallback {
    private String _url;
    private VisemeHolder _holder;
    private MouthMovements _mouthMovements;
    private final String TAG = "VisemeConnection";

    public VisemeConnection(String url, MouthMovements mouthMovements) {
        this._mouthMovements = mouthMovements;
        this._url = url;
    }

    public void run2() {
        try {
            this.getXml();
            this._mouthMovements.gotVisimes(this.getHolder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void run() {
        try {
            this.getXml();
            this._mouthMovements.gotVisimes(this.getHolder());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void getXml() throws IOException, ParserConfigurationException, SAXException {
        this._url = this._url.replaceAll("%3D", "=");
        URL url = new URL(this._url);
        URLConnection urlConnection = url.openConnection();
        BufferedInputStream inputStream = new BufferedInputStream(urlConnection.getInputStream());
        VisemeSAXParser viz = new VisemeSAXParser(this);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setFeature("http://xml.org/sax/features/namespaces", false);
        factory.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        SAXParser parser = factory.newSAXParser();
        parser.parse((InputStream)inputStream, (DefaultHandler)viz);
    }

    public void setHolder(VisemeHolder h) {
        this._holder = h;
    }

    public VisemeHolder getHolder() {
        return this._holder;
    }
}

