/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.HandlerThread;
import android.widget.Toast;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.ispeech.Marker;
import org.ispeech.MarkerCallback;
import org.ispeech.MarkerHolder;
import org.ispeech.MarkerMovements;
import org.ispeech.MetaType;
import org.ispeech.MouthMovements;
import org.ispeech.SpeechSynthesisEvent;
import org.ispeech.Synthesizer;
import org.ispeech.UtilitiesInternal;
import org.ispeech.Viseme;
import org.ispeech.VisemeCallback;
import org.ispeech.VisemeHolder;
import org.ispeech.core.InternalResources;
import org.ispeech.core.TTSEngine;
import org.ispeech.error.ApiException;
import org.ispeech.error.BusyException;
import org.ispeech.error.InvalidApiKeyException;
import org.ispeech.error.NoNetworkException;
import org.ispeech.iSpeechFramework;
import org.ispeech.tools.CommandResult;
import org.ispeech.tools.HttpUtils;
import org.ispeech.tools.Utilities;

public class SpeechSynthesis
implements Synthesizer {
    private static final String TAG = "iSpeech SDK";
    private Context _context;
    private String apiKey;
    private Thread eventThread;
    private int mediaTime = -1;
    private boolean speechAttempted = false;
    private boolean stopTrigger = false;
    private boolean wtfidontevenknow = false;
    private ConvertResult convertResult = null;
    private TTSEngine ttsEngine;
    private AudioManager audioManager;
    private Thread ttsEngineWorkThread;
    private CallBackThread ttsCallbackThread;
    private int streamType = 3;
    private MarkerCallback markerCallback = null;
    private VisemeCallback visemeCallback = null;
    private MarkerHolder markerHolder = null;
    private VisemeHolder visemeHolder = null;
    private boolean markerHolderReady = false;
    private boolean visemeHolderReady = false;
    private String markerText;
    private Vector<SpeechSynthesisEvent> speechEventListeners = new Vector();
    private static SpeechSynthesis _synthesis = null;
    private MediaPlayer.OnCompletionListener onCompletion = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mp) {
            SpeechSynthesis.this.audioManager.setStreamSolo(InternalResources.STREAM_TYPE, false);
            HandlerThread handlerThread = new HandlerThread("OnCompletion"){

                public void run() {
                    SpeechSynthesis.this.stateChangedListener.changeState(1);
                }
            };
            handlerThread.start();
        }
    };
    private MediaPlayer.OnErrorListener onError = new MediaPlayer.OnErrorListener(){

        public boolean onError(MediaPlayer mp, int what, int extra) {
            SpeechSynthesis.this.audioManager.setStreamSolo(InternalResources.STREAM_TYPE, false);
            SpeechSynthesis.this.createEventThread(SpeechSynthesisEvent.EventType.PLAY_FAILURE, new Exception("MediaPlayer Error: (" + what + "," + extra + ")"));
            return true;
        }
    };
    private StateChangedListener stateChangedListener = new StateChangedListener(){

        public void changeState(int state) {
            if (state == 2) {
                SpeechSynthesis.this.createEventThread(SpeechSynthesisEvent.EventType.PLAY_STARTED, null);
            }
            if (state == 4 || state == 3) {
                ((SpeechSynthesis)SpeechSynthesis.this).ttsEngine.startedSpeaking = false;
                SpeechSynthesis.this.showBanner();
            }
            if (state == 3) {
                ((SpeechSynthesis)SpeechSynthesis.this).ttsEngine.startedSpeaking = false;
                SpeechSynthesis.this.ttsEngine.release();
                SpeechSynthesis.this.playOnlyAd();
            }
            if (state == 1 || state == 3) {
                CommandResult r;
                ((SpeechSynthesis)SpeechSynthesis.this).ttsEngine.startedSpeaking = false;
                CommandResult commandResult = r = SpeechSynthesis.this.convertResult == null ? null : ((SpeechSynthesis)SpeechSynthesis.this).convertResult.result;
                if (state == 1) {
                    SpeechSynthesis.this.createEventThread(SpeechSynthesisEvent.EventType.PLAY_SUCCESSFUL, null);
                } else {
                    SpeechSynthesis.this.createEventThread(SpeechSynthesisEvent.EventType.PLAY_STOPPED, null);
                }
                new HandlerThread("Utilities.processCommand"){

                    public void run() {
                        try {
                            Utilities.processCommand(SpeechSynthesis.this._context, r, SpeechSynthesis.this.apiKey, 5000);
                        }
                        catch (InvalidApiKeyException invalidApiKeyException) {
                            // empty catch block
                        }
                    }
                }.start();
            }
        }
    };

    public TTSEngine getTTSEngine() {
        return this.ttsEngine;
    }

    private SpeechSynthesis(Context context, String apiKey) throws InvalidApiKeyException {
        if (apiKey == null || apiKey.length() != 32) {
            throw new InvalidApiKeyException();
        }
        this.apiKey = apiKey;
        this._context = context;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.ttsEngine = TTSEngine.getInstance(InternalResources.getAPIUrl(context), apiKey);
        this.ttsEngine.setMeta(Utilities.getMetaInfo(context));
    }

    public static SpeechSynthesis getInstance(Context context, Activity callingActivity) throws InvalidApiKeyException {
        if (_synthesis == null) {
            _synthesis = new SpeechSynthesis(context, Utilities.getApiKey(context));
            callingActivity.setVolumeControlStream(InternalResources.STREAM_TYPE);
        } else {
            SpeechSynthesis._synthesis._context = context;
        }
        return _synthesis;
    }

    public VisemeHolder getVisemeInfo(String text, String voice, String speed, String format) throws InvalidApiKeyException {
        MouthMovements _voiceController = new MouthMovements(text, this.apiKey, voice, speed, format);
        VisemeHolder vHolder = _voiceController.getVisemeHolder();
        Viseme v = vHolder.getViseme().get(1);
        return vHolder;
    }

    public MarkerHolder getMarkerInfo(String text, String voice, String speed, String format) throws InvalidApiKeyException {
        MarkerMovements _markerController = new MarkerMovements(text, this.apiKey, voice, speed, format);
        MarkerHolder mHolder = _markerController.getMarkerHolder();
        Marker v = mHolder.getMarker().get(1);
        return mHolder;
    }

    public static SpeechSynthesis getInstance(Activity callingActivity) throws InvalidApiKeyException {
        return SpeechSynthesis.getInstance(callingActivity.getApplicationContext(), callingActivity);
    }

    private void showProcessingDialog() {
        Intent i = new Intent(this._context, iSpeechFramework.class);
        i.putExtra("type", 3);
        i.putExtra("ispeech_api_key", this.apiKey);
        i.setFlags(0x10000000);
    }

    public void toDisableTheDialogContact_salesATiSpeechDOTorg() {
    }

    public void setStreamType(int streamType) {
        InternalResources.setStreamType(streamType);
    }

    public void setSpeakWhenSilent(boolean alwaysSpeak) {
        InternalResources.alwaysSpeak(alwaysSpeak);
    }

    public byte[] downloadByteArray(String text) throws BusyException, NoNetworkException {
        try {
            return this.ttsEngine.downloadByteArray(this._context, text);
        }
        catch (IOException e) {
            e.printStackTrace();
            byte[] b = null;
            return b;
        }
    }

    public void speak(final String text) throws BusyException, NoNetworkException {
        try {
            if (!UtilitiesInternal.hasFrameworkActivityDefinedInManifest(this._context)) {
                this.createEventThread(SpeechSynthesisEvent.EventType.PLAY_FAILURE, new IllegalArgumentException("No API Key detected."));
                return;
            }
            if (this.ttsEngine.isSpeaking()) {
                this.createEventThread(SpeechSynthesisEvent.EventType.PLAY_FAILURE, new BusyException("Device is busy?"));
                return;
            }
            if (text == null || text.length() == 0) {
                this.createEventThread(SpeechSynthesisEvent.EventType.PLAY_FAILURE, new IllegalArgumentException("Text is Empty."));
                return;
            }
            this.showProcessingDialog();
            this.setupTTSEngine();
            this.speechAttempted = true;
            this.ttsEngineWorkThread = new Thread(){

                public void run() {
                    try {
                        try {
                            SpeechSynthesis.this.ttsEngine.speak(SpeechSynthesis.this._context, text);
                            while (true) {
                                if (((SpeechSynthesis)SpeechSynthesis.this).ttsEngine.startedSpeaking) {
                                    SpeechSynthesis.this.stateChangedListener.changeState(2);
                                    break;
                                }
                                Thread.sleep(100L);
                            }
                        }
                        catch (IOException e) {
                            SpeechSynthesis.this.audioManager.setStreamSolo(InternalResources.STREAM_TYPE, false);
                            SpeechSynthesis.this.createEventThread(SpeechSynthesisEvent.EventType.PLAY_FAILURE, e);
                            SpeechSynthesis.this.speechAttempted = false;
                        }
                        catch (InterruptedException e) {
                            SpeechSynthesis.this.ttsEngine.cancelTTS();
                            e.printStackTrace();
                            SpeechSynthesis.this.speechAttempted = false;
                        }
                    }
                    finally {
                        SpeechSynthesis.this.speechAttempted = false;
                    }
                }
            };
            this.ttsEngineWorkThread.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupTTSEngine() {
        this.ttsEngine.setResponseHandler(new TTSEngine.ResponseHandler(){

            public void onResponse(HttpResponse response) {
                if (response.getStatusLine().getStatusCode() == 202) {
                    try {
                        Map<String, String> result = HttpUtils.parseNameValuePairEntity(response.getEntity());
                        throw new ApiException(result.get("message"));
                    }
                    catch (Exception e) {
                        SpeechSynthesis.this.createEventThread(SpeechSynthesisEvent.EventType.PLAY_FAILURE, e);
                    }
                } else if (response.getStatusLine().getStatusCode() == 200) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    Header[] headerArray = response.getAllHeaders();
                    int n = headerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Header h = headerArray[n2];
                        map.put(h.getName().toLowerCase(), h.getValue());
                        ++n2;
                    }
                    String data = null;
                    if (map.containsKey("x-data")) {
                        data = (String)map.get("x-data");
                    }
                    int len = 0;
                    try {
                        len = Integer.valueOf((String)map.get("x-time-length"));
                    }
                    catch (NumberFormatException e2) {
                        len = 0;
                    }
                    int mode = 0;
                    int ct = 0;
                    String ad = null;
                    if (map.containsKey("x-ad")) {
                        ad = (String)map.get("x-ad");
                    }
                    String modeString = null;
                    if (map.containsKey("x-mode")) {
                        modeString = (String)map.get("x-mode");
                    }
                    if (modeString != null && modeString.length() > 0) {
                        try {
                            mode = Integer.parseInt(modeString);
                        }
                        catch (NumberFormatException e1) {
                            mode = 0;
                        }
                    }
                    BannerAd b = null;
                    if (ad != null && ad.length() > 0) {
                        if (map.containsKey("x-banner")) {
                            b = BannerAd.parseData((String)map.get("x-banner"));
                        }
                        ct = Integer.parseInt((String)map.get("x-content-time-length"));
                    }
                    try {
                        if (data != null) {
                            SpeechSynthesis.this.convertResult = new ConvertResult(Utilities.cleanData(data), len, mode, ad, b, ct);
                        } else {
                            SpeechSynthesis.this.convertResult = new ConvertResult(null, len, mode, ad, b, ct);
                        }
                    }
                    catch (Exception e) {
                        SpeechSynthesis.this.createEventThread(SpeechSynthesisEvent.EventType.PLAY_FAILURE, e);
                        return;
                    }
                }
            }
        });
        this.ttsEngine.setOnCompletionListener(this.onCompletion);
        this.ttsEngine.setOnErrorListener(this.onError);
        this.ttsEngine.setAudioStreamType(InternalResources.STREAM_TYPE);
        this.ttsEngine.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                mp.start();
                SpeechSynthesis.this.audioManager.setStreamSolo(InternalResources.STREAM_TYPE, true);
            }
        });
    }

    public void setSpeechSynthesisEvent(SpeechSynthesisEvent speechSynthesisEvent) {
        this.speechEventListeners.add(speechSynthesisEvent);
    }

    public void unregisterSpeechSynthesisEventListener(SpeechSynthesisEvent speechSynthesisEvent) {
        this.speechEventListeners.remove(speechSynthesisEvent);
    }

    public void setVoiceType(String voiceType) {
        this.ttsEngine.setVoice(voiceType);
    }

    private void playOnlyAd() {
        try {
            if (this.convertResult != null && this.convertResult.adURL != null) {
                MediaPlayer mp = new MediaPlayer();
                mp.setDataSource(this.convertResult.adURL);
                mp.prepare();
                mp.start();
                mp.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mp) {
                        mp.release();
                    }
                });
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showBanner() {
        if (this.convertResult.banner != null && this.convertResult.mode != 2) {
            Intent i = new Intent(this._context, iSpeechFramework.class);
            i.putExtra("type", 1);
            i.putExtra("iu", this.convertResult.banner.imageURL);
            i.putExtra("cu", this.convertResult.banner.clickURL);
            i.putExtra("h", this.convertResult.banner.height);
            i.putExtra("w", this.convertResult.banner.width);
            i.setFlags(0x10000000);
            this._context.startActivity(i);
        }
    }

    public int getCurrentPosition() {
        return this.ttsEngine.getCurrentPosition();
    }

    private Thread createEventThread(final SpeechSynthesisEvent.EventType type, final Object param) {
        this.eventThread = new Thread(){

            public void run() {
                if (SpeechSynthesis.this.speechEventListeners != null) {
                    for (SpeechSynthesisEvent sse : SpeechSynthesis.this.speechEventListeners) {
                        sse.stateChanged(type, param);
                    }
                }
                if (SpeechSynthesis.this.markerCallback != null) {
                    switch (type) {
                        case PLAY_STARTED: {
                            SpeechSynthesis.this.ttsCallbackThread = new CallBackThread(SpeechSynthesis.this.markerText, 1);
                            SpeechSynthesis.this.markerCallback.onPlayStart();
                            SpeechSynthesis.this.ttsCallbackThread.start();
                            break;
                        }
                        case PLAY_SUCCESSFUL: {
                            SpeechSynthesis.this.markerCallback.onPlaySuccessful();
                            if (SpeechSynthesis.this.ttsCallbackThread == null) break;
                            SpeechSynthesis.this.ttsCallbackThread.setThreadRunning(false);
                            break;
                        }
                        case PLAY_STOPPED: {
                            SpeechSynthesis.this.markerCallback.onPlayStopped();
                            if (SpeechSynthesis.this.ttsCallbackThread == null) break;
                            SpeechSynthesis.this.ttsCallbackThread.setThreadRunning(false);
                            break;
                        }
                        case PLAY_FAILURE: {
                            SpeechSynthesis.this.markerCallback.onPlayFailed((Exception)param);
                            if (SpeechSynthesis.this.ttsCallbackThread == null) break;
                            SpeechSynthesis.this.ttsCallbackThread.setThreadRunning(false);
                            break;
                        }
                        case PLAY_CANCELED: {
                            SpeechSynthesis.this.markerCallback.onPlayCanceled();
                            if (SpeechSynthesis.this.ttsCallbackThread == null) break;
                            SpeechSynthesis.this.ttsCallbackThread.setThreadRunning(false);
                        }
                    }
                }
                if (SpeechSynthesis.this.visemeCallback != null) {
                    switch (type) {
                        case PLAY_STARTED: {
                            SpeechSynthesis.this.ttsCallbackThread = new CallBackThread(SpeechSynthesis.this.markerText, 0);
                            SpeechSynthesis.this.visemeCallback.onPlayStart();
                            SpeechSynthesis.this.ttsCallbackThread.start();
                            break;
                        }
                        case PLAY_SUCCESSFUL: {
                            SpeechSynthesis.this.visemeCallback.onPlaySuccessful();
                            if (SpeechSynthesis.this.ttsCallbackThread == null) break;
                            SpeechSynthesis.this.ttsCallbackThread.setThreadRunning(false);
                            break;
                        }
                        case PLAY_STOPPED: {
                            SpeechSynthesis.this.visemeCallback.onPlayStopped();
                            if (SpeechSynthesis.this.ttsCallbackThread == null) break;
                            SpeechSynthesis.this.ttsCallbackThread.setThreadRunning(false);
                            break;
                        }
                        case PLAY_FAILURE: {
                            SpeechSynthesis.this.visemeCallback.onPlayFailed((Exception)param);
                            if (SpeechSynthesis.this.ttsCallbackThread == null) break;
                            SpeechSynthesis.this.ttsCallbackThread.setThreadRunning(false);
                            break;
                        }
                        case PLAY_CANCELED: {
                            SpeechSynthesis.this.visemeCallback.onPlayCanceled();
                            if (SpeechSynthesis.this.ttsCallbackThread == null) break;
                            SpeechSynthesis.this.ttsCallbackThread.setThreadRunning(false);
                        }
                    }
                }
            }
        };
        Handler handler = new Handler(this._context.getMainLooper());
        handler.post((Runnable)this.eventThread);
        return this.eventThread;
    }

    public void stop() {
        if (this.ttsEngine.isSpeaking()) {
            int pos = this.ttsEngine.getCurrentPosition();
            if (this.convertResult == null || this.convertResult.contentTimeLength <= 0 || pos < this.convertResult.contentTimeLength) {
                this.mediaTime = pos;
                this.ttsEngine.stop();
                this.wtfidontevenknow = true;
                new Thread(){

                    public void run() {
                        SpeechSynthesis.this.ttsEngine.setOnCompletionListener(null);
                        SpeechSynthesis.this.stateChangedListener.changeState(3);
                        SpeechSynthesis.this.wtfidontevenknow = false;
                    }
                }.start();
            }
        } else if (this.ttsEngine.isRunning() && !this.wtfidontevenknow) {
            this.ttsEngine.setEarlyStop();
        }
        this.audioManager.setStreamSolo(InternalResources.STREAM_TYPE, false);
    }

    public void cancel() {
        this.stop();
        this.createEventThread(SpeechSynthesisEvent.EventType.PLAY_CANCELED, null);
        if (this.ttsEngine.isSpeaking()) {
            this.ttsEngine.cancelTTS();
        } else if (this.ttsEngineWorkThread != null) {
            this.ttsEngineWorkThread.interrupt();
        }
        if (this.markerCallback != null) {
            this.markerCallback.onPlayCanceled();
        }
    }

    public void setConnectionTimeout(int timeout) {
        if (this.ttsEngine != null) {
            this.ttsEngine.setSocketTimeout(timeout);
        }
    }

    public void addMeta(MetaType type, String value) {
        this.ttsEngine.addMeta(type.getValue(), value);
    }

    public void addOptionalCommand(String command, String parameter) {
        this.ttsEngine.addOptionalCommand(command, parameter);
    }

    public void clearOptionalCommand() {
        this.ttsEngine.clearOptionalCommand();
    }

    public void addMarkerCallback(MarkerCallback mc) {
        this.markerCallback = mc;
    }

    public void addVisemeCallback(VisemeCallback mc) {
        this.visemeCallback = mc;
    }

    public void setUpMarkers(String ttsText) {
        this.markerText = ttsText;
        Object[] parameters = new Object[]{this, ttsText};
        AsyncTask<Object, Void, MarkerHolder> task = new AsyncTask<Object, Void, MarkerHolder>(){

            protected MarkerHolder doInBackground(Object ... params) {
                try {
                    MarkerHolder tempMarkerHolder = ((SpeechSynthesis)params[0]).getMarkerInfo((String)params[1], "usenglishfemale", "0", "mp3");
                    return tempMarkerHolder;
                }
                catch (InvalidApiKeyException e) {
                    Toast.makeText((Context)SpeechSynthesis.this._context, (CharSequence)"ERROR: Invalid API key", (int)1).show();
                    return null;
                }
            }

            protected void onPostExecute(MarkerHolder tempMarkerHolder) {
                SpeechSynthesis.this.markerHolder = tempMarkerHolder;
                SpeechSynthesis.this.markerHolderReady = true;
                if (SpeechSynthesis.this.markerCallback != null) {
                    SpeechSynthesis.this.markerCallback.onMarkerHolderReady();
                }
            }
        };
        task.execute(parameters);
    }

    public void setUpVisemes(String ttsText) {
        this.markerText = ttsText;
        Object[] parameters = new Object[]{this, ttsText};
        AsyncTask<Object, Void, VisemeHolder> task = new AsyncTask<Object, Void, VisemeHolder>(){

            protected VisemeHolder doInBackground(Object ... params) {
                try {
                    VisemeHolder tempMarkerHolder = ((SpeechSynthesis)params[0]).getVisemeInfo((String)params[1], "usenglishfemale", "0", "mp3");
                    return tempMarkerHolder;
                }
                catch (InvalidApiKeyException e) {
                    Toast.makeText((Context)SpeechSynthesis.this._context, (CharSequence)"ERROR: Invalid API key", (int)1).show();
                    return null;
                }
            }

            protected void onPostExecute(VisemeHolder tempVisemeHolder) {
                SpeechSynthesis.this.visemeHolder = tempVisemeHolder;
                SpeechSynthesis.this.visemeHolderReady = true;
                if (SpeechSynthesis.this.visemeCallback != null) {
                    SpeechSynthesis.this.visemeCallback.onVisemeHolderReady();
                }
            }
        };
        task.execute(parameters);
    }

    public boolean getMarkerHolderReady() {
        return this.markerHolderReady;
    }

    public MarkerHolder getMarkerHolder() {
        return this.markerHolder;
    }

    private static class BannerAd {
        public int width;
        public int height;
        public String imageURL;
        public String clickURL;

        private BannerAd(int width, int height, String imageURL, String clickURL) {
            this.width = width;
            this.height = height;
            this.imageURL = imageURL;
            this.clickURL = clickURL;
        }

        public static BannerAd parseData(String data) {
            try {
                String[] s = new String[4];
                int p = data.indexOf("|");
                int i = 0;
                int x = 0;
                while (x < s.length) {
                    s[x] = p == -1 ? data.substring(i) : data.substring(i, p);
                    ++x;
                    i = p + 1;
                    p = data.indexOf("|", i);
                }
                return new BannerAd(Integer.parseInt(s[0]), Integer.parseInt(s[1]), s[2], s[3]);
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    private class CallBackThread
    extends Thread {
        boolean threadRunning = true;
        String text;
        int type;
        public static final int VISEME = 0;
        public static final int MARKER = 1;

        public CallBackThread(String text, int theType) {
            this.text = text;
            this.type = theType;
        }

        public void setThreadRunning(boolean thread) {
            this.threadRunning = thread;
        }

        public void run() {
            block24: {
                block25: {
                    if (this.type != 1) break block25;
                    int words = SpeechSynthesis.this.markerHolder.getWords();
                    int threadTimeout = 5000;
                    int timePassed = 300000;
                    int timeNext = 0;
                    int wordStartLoc = 0;
                    int wordStopLoc = 0;
                    float baseTime = 0.0f;
                    try {
                        timePassed = SpeechSynthesis.this.getCurrentPosition();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                    while (timePassed >= 300000) {
                        try {
                            Thread.sleep(100L);
                            timePassed = SpeechSynthesis.this.getCurrentPosition();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    int i = 0;
                    while (i < words) {
                        String word = SpeechSynthesis.this.markerHolder.getText(i);
                        wordStartLoc = this.text.indexOf(word, wordStopLoc);
                        wordStopLoc = wordStartLoc + word.length();
                        timeNext += SpeechSynthesis.this.markerHolder.getLength(i);
                        if (!this.threadRunning) break block24;
                        SpeechSynthesis.this.markerCallback.onNewWord(wordStartLoc, wordStopLoc);
                        try {
                            timePassed = SpeechSynthesis.this.getCurrentPosition();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            return;
                        }
                        baseTime = System.nanoTime();
                        while (timePassed < timeNext) {
                            try {
                                timePassed = SpeechSynthesis.this.getCurrentPosition();
                            }
                            catch (Exception e1) {
                                e1.printStackTrace();
                                return;
                            }
                            int deltaTime = (int)(((float)System.nanoTime() - baseTime) / 1000000.0f);
                            if (deltaTime >= 5000) {
                                this.threadRunning = false;
                            }
                            if (!this.threadRunning) break;
                        }
                        ++i;
                    }
                    break block24;
                }
                if (this.type != 0) break block24;
                int words = SpeechSynthesis.this.visemeHolder.getFrames();
                int threadTimeout = 5000;
                int timePassed = 300000;
                int timeNext = 0;
                float baseTime = 0.0f;
                try {
                    timePassed = SpeechSynthesis.this.getCurrentPosition();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
                while (timePassed >= 300000) {
                    try {
                        Thread.sleep(100L);
                        timePassed = SpeechSynthesis.this.getCurrentPosition();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                int i = 0;
                while (i < words) {
                    timeNext += SpeechSynthesis.this.visemeHolder.getLength(i);
                    if (!this.threadRunning) break;
                    SpeechSynthesis.this.visemeCallback.onNewViseme(SpeechSynthesis.this.visemeHolder.getMouth(i));
                    try {
                        timePassed = SpeechSynthesis.this.getCurrentPosition();
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        return;
                    }
                    baseTime = System.nanoTime();
                    while (timePassed < timeNext) {
                        try {
                            timePassed = SpeechSynthesis.this.getCurrentPosition();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                            return;
                        }
                        int deltaTime = (int)(((float)System.nanoTime() - baseTime) / 1000000.0f);
                        if (deltaTime >= 5000) {
                            this.threadRunning = false;
                        }
                        if (!this.threadRunning) break;
                    }
                    ++i;
                }
            }
        }
    }

    private class ConvertResult {
        public int mode;
        public String adURL;
        public int contentTimeLength;
        public BannerAd banner;
        public CommandResult result;
        public int length;

        public ConvertResult(CommandResult result, int length, int mode, String adURL, BannerAd banner, int contentTimeLength) {
            this.result = result;
            this.length = length;
            this.mode = mode;
            this.adURL = adURL;
            this.banner = banner;
            this.contentTimeLength = contentTimeLength;
        }
    }

    static interface StateChangedListener {
        public static final int CLOSED = 1;
        public static final int STARTED = 2;
        public static final int STOPPED = 3;
        public static final int EXPIRED = 4;
        public static final int CANCELED = 5;

        public void changeState(int var1);
    }
}

