/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech;

import android.content.Context;
import org.ispeech.FreeformRecognizerImpl;
import org.ispeech.FreeformType;
import org.ispeech.MetaType;
import org.ispeech.Recognizer;
import org.ispeech.SpeechRecognizerEvent;
import org.ispeech.error.BusyException;
import org.ispeech.error.InvalidApiKeyException;
import org.ispeech.error.NoNetworkException;
import org.ispeech.tools.Utilities;

public class SpeechRecognizer
implements Recognizer {
    private String _key;
    private Recognizer currentRecognizer;
    private FreeformRecognizerImpl freeformRecognizer;
    private static SpeechRecognizer instance;

    public static SpeechRecognizer getInstance(Context context) throws InvalidApiKeyException {
        String apiKey = Utilities.getApiKey(context);
        if (instance == null) {
            instance = new SpeechRecognizer(context, apiKey);
        } else {
            FreeformRecognizerImpl.getInstance(context, apiKey);
            SpeechRecognizer.instance._key = apiKey;
        }
        return instance;
    }

    private SpeechRecognizer(Context context, String apiKey) throws InvalidApiKeyException {
        if (apiKey == null || apiKey.length() != 32) {
            throw new InvalidApiKeyException();
        }
        this._key = apiKey;
        this.freeformRecognizer = FreeformRecognizerImpl.getInstance(context);
    }

    public void startRecord(SpeechRecognizerEvent speechRecognizerEvent) throws BusyException, NoNetworkException {
        try {
            this.currentRecognizer.startRecord(speechRecognizerEvent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSilenceDetection(boolean silenceDetection) {
        this.freeformRecognizer.setSilenceDetection(silenceDetection);
    }

    public void stopRecord() {
        this.currentRecognizer.stopRecord();
    }

    public void cancelRecord() {
        this.currentRecognizer.cancelRecord();
    }

    public void toDisableTheDialogContact_salesATiSpeechDOTorg() {
    }

    public void cancelProcessing() {
        this.currentRecognizer.cancelProcessing();
    }

    public void clearCommand() {
    }

    public void addCommand(String[] commandPhrases) {
        this.currentRecognizer.addCommand(commandPhrases);
    }

    public void setFreeForm(FreeformType freeFormType) {
        this.currentRecognizer = this.freeformRecognizer;
        this.currentRecognizer.setFreeForm(freeFormType);
    }

    public FreeformType getFreeForm() {
        return this.currentRecognizer.getFreeForm();
    }

    public boolean isRunning() {
        return this.currentRecognizer.isRunning();
    }

    public void addAlias(String name, String[] values) {
        this.currentRecognizer.addAlias(name.toUpperCase(), values);
    }

    public void clearAlias() {
    }

    public void setTimeout(int timeout) {
        this.freeformRecognizer.setTimeout(timeout);
    }

    public void addMeta(MetaType type, String value) {
        this.freeformRecognizer.addMeta(type, value);
    }

    public void clearOptionalCommand() {
        this.freeformRecognizer.clearOptionalCommand();
    }

    public void addOptionalCommand(String command, String parameter) {
        this.freeformRecognizer.addOptionalCommand(command, parameter);
    }

    public void addCommand(String phrase) {
        this.currentRecognizer.addCommand(phrase);
    }

    public void setModel(String model) {
        this.freeformRecognizer.setModel(model);
    }

    public void setLocale(String locale) {
        this.freeformRecognizer.setLocale(locale);
    }

    public void setChime(boolean isOn) {
        this.freeformRecognizer.setChime(isOn);
    }
}

