/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech;

import org.ispeech.Marker;
import org.ispeech.MarkerHolder;
import org.ispeech.ParserMarkerCallback;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MarkerSAXParser
extends DefaultHandler {
    private String _curr;
    private boolean _inViseme = false;
    private MarkerHolder _holder;
    private int _len = 0;
    private String _text = "";
    private String _voice = "";
    private int _words;
    private int _start = 0;
    private int _end = 0;
    private ParserMarkerCallback _callback;

    public MarkerSAXParser(ParserMarkerCallback callback) {
        this._callback = callback;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this._curr = new String(ch, start, length);
    }

    public void endDocument() throws SAXException {
        while (this._holder == null) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this._callback.setHolder(this._holder);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (qName.equalsIgnoreCase("word")) {
            this._inViseme = true;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this._inViseme) {
            if (qName.equalsIgnoreCase("start")) {
                this._start = Integer.parseInt(this._curr);
            } else if (qName.equalsIgnoreCase("end")) {
                this._end = Integer.parseInt(this._curr);
            } else if (qName.equalsIgnoreCase("text")) {
                Marker temp = new Marker(this._start, this._end, this._curr);
                this._holder.addMarker(temp);
            }
        } else if (qName.equalsIgnoreCase("text")) {
            this._text = this._curr;
        } else if (qName.equalsIgnoreCase("voice")) {
            this._voice = this._curr;
        } else if (qName.equalsIgnoreCase("length")) {
            this._len = Integer.parseInt(this._curr);
        } else if (qName.equalsIgnoreCase("words")) {
            this._holder = new MarkerHolder(this._text, this._voice, this._len, Integer.parseInt(this._curr));
        }
        this._curr = "";
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }
}

