/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.ispeech.Marker;
import org.ispeech.MarkerConnection;
import org.ispeech.MarkerHolder;

public class MarkerMovements
extends TimerTask {
    private String _xml;
    private String _urlBaseVisme = "http://api.ispeech.org/api/rest/?apikey=";
    private String _apiKey;
    private String _voice;
    private String _speed;
    private String _format;
    private String _text;
    private boolean _valid = false;
    public MarkerHolder _holder;
    private Timer timer;
    final String TAG = "MouthMovements";
    private int index = 0;
    private long start = 0L;
    private long time = 0L;

    public MarkerMovements(String text) {
        this._text = text;
        this.getVisimes();
    }

    public MarkerMovements(String text, String apiKey) {
        this._apiKey = apiKey;
        this._urlBaseVisme = String.valueOf(this._urlBaseVisme) + apiKey;
        this._urlBaseVisme = String.valueOf(this._urlBaseVisme) + "&action=markers&";
        this._text = text;
        this.getVisimes();
    }

    public MarkerMovements(String text, String apiKey, String voice, String speed, String format) {
        this._apiKey = apiKey;
        this._urlBaseVisme = String.valueOf(this._urlBaseVisme) + apiKey;
        this._urlBaseVisme = String.valueOf(this._urlBaseVisme) + "&action=markers";
        this._urlBaseVisme = String.valueOf(this._urlBaseVisme) + "&voice=" + voice;
        this._urlBaseVisme = String.valueOf(this._urlBaseVisme) + "&speed=" + speed;
        this._urlBaseVisme = String.valueOf(this._urlBaseVisme) + "&format=" + format + "&";
        this._text = text;
        this.getVisimes();
    }

    private void getVisimes() {
        MarkerConnection conn = new MarkerConnection(this.getURL(), this);
        conn.run2();
        this._holder = conn.getHolder();
    }

    public void gotMarkers(MarkerHolder holder) {
        this._holder = holder;
        this._holder.addFrame();
        this._holder.getMarker().addElement(new Marker(holder.getTotalLength() + 1, holder.getTotalLength() + 1000, ""));
        Vector markerMovements = holder._marker;
        if (markerMovements != null && markerMovements.size() > 0) {
            this._valid = true;
        }
    }

    public MarkerHolder getMarkerHolder() {
        return this._holder;
    }

    public void playMouth() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer();
        this.index = 0;
        this.start = System.currentTimeMillis();
        this.timer.scheduleAtFixedRate((TimerTask)this, 0L, 15L);
    }

    public String getText() {
        return this._text;
    }

    private String getURL() {
        String encodedText = "";
        try {
            encodedText = URLEncoder.encode(this._text, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String finalString = String.valueOf(this._urlBaseVisme) + "text=" + encodedText + "&deviceType=Android";
        return finalString;
    }

    public boolean validVismes() {
        return this._valid;
    }

    public static String getMouthImage(int index) {
        return "0";
    }

    public void setTime() {
    }

    public void run() {
    }
}

