/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.BitmapFactory;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import java.io.InputStream;
import org.ispeech.SpeechSynthesis;
import org.ispeech.SpeechSynthesisEvent;
import org.ispeech.error.InvalidApiKeyException;
import org.ispeech.tools.Utilities;

public class MProcessingDialog
extends Dialog
implements Runnable {
    private static final String TAG = "iSpeech SDK";
    Dialog _self = this;
    Context _context;
    SpeechSynthesis speechSyntesisInstance;
    boolean audioPlayStarted = false;
    private final int MINIMUM_DIALOG_TIME = 1500;
    private long processingStartTime;
    private long processingEndTime;
    private SpeechSynthesisEvent speechSynthesisEventListener;
    private Activity _callingActivity;

    public MProcessingDialog(Activity callingActivity) {
        super((Context)callingActivity);
        this._callingActivity = callingActivity;
        this.processingStartTime = System.currentTimeMillis();
        try {
            this.speechSyntesisInstance = SpeechSynthesis.getInstance(this._callingActivity);
        }
        catch (InvalidApiKeyException invalidApiKeyException) {
            // empty catch block
        }
        this.setupDialogBody((Context)callingActivity);
        this.setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                MProcessingDialog.this.speechSyntesisInstance.cancel();
                MProcessingDialog.this.dismiss();
            }
        });
        this.speechSynthesisEventListener = new SpeechSynthesisEvent(){

            public void onPlayStart() {
                MProcessingDialog.this.audioPlayStarted = true;
                MProcessingDialog.this.processingEndTime = System.currentTimeMillis();
                if (MProcessingDialog.this.processingEndTime - MProcessingDialog.this.processingStartTime > 1500L) {
                    MProcessingDialog.this.dismiss();
                } else {
                    MProcessingDialog.this.startDialogWaitingThread();
                }
            }

            public void onPlayFailed(Exception e) {
                MProcessingDialog.this.audioPlayStarted = false;
                MProcessingDialog.this.processingEndTime = System.currentTimeMillis();
                if (MProcessingDialog.this.processingEndTime - MProcessingDialog.this.processingStartTime > 1500L) {
                    MProcessingDialog.this.dismiss();
                } else {
                    MProcessingDialog.this.startDialogWaitingThread();
                }
            }
        };
        this.speechSyntesisInstance.setSpeechSynthesisEvent(this.speechSynthesisEventListener);
    }

    public void dismiss() {
        this.speechSyntesisInstance.unregisterSpeechSynthesisEventListener(this.speechSynthesisEventListener);
        super.dismiss();
        if (this.getOwnerActivity() != null) {
            this.getOwnerActivity().finish();
        }
    }

    private void setupDialogBody(Context context) {
        this.requestWindowFeature(1);
        LinearLayout mainLinearLayoutContainer = new LinearLayout(context);
        mainLinearLayoutContainer.setOrientation(1);
        mainLinearLayoutContainer.addView(this.getiSpeechLogoView(context));
        mainLinearLayoutContainer.addView(this.getProgressBarView(context));
        mainLinearLayoutContainer.addView(this.getCancelButtonView(context));
        this.setContentView((View)mainLinearLayoutContainer);
    }

    private View getCancelButtonView(Context context) {
        Button cancelButton = new Button(context);
        cancelButton.setText((CharSequence)"Cancel");
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MProcessingDialog.this._self.cancel();
            }
        });
        return cancelButton;
    }

    private View getiSpeechLogoView(Context context) {
        ImageView ispeechLogo = new ImageView(context);
        ispeechLogo.setImageBitmap(BitmapFactory.decodeStream((InputStream)MProcessingDialog.class.getClassLoader().getResourceAsStream("org/ispeech/raw/logo.png")));
        return ispeechLogo;
    }

    private View getProgressBarView(Context context) {
        LinearLayout progressBarContainer = new LinearLayout(context);
        LinearLayout.LayoutParams pbcParams = new LinearLayout.LayoutParams(-1, -2);
        pbcParams.setMargins(0, (int)Utilities.dp2px(10.0f, context), 0, (int)Utilities.dp2px(10.0f, context));
        progressBarContainer.setLayoutParams((ViewGroup.LayoutParams)pbcParams);
        progressBarContainer.setGravity(17);
        ProgressBar progressBar = new ProgressBar(context);
        progressBar.setIndeterminate(true);
        progressBarContainer.addView((View)progressBar);
        return progressBarContainer;
    }

    private void startDialogWaitingThread() {
        new Thread(this).start();
    }

    public void run() {
        try {
            Thread.sleep(1500L - (this.processingEndTime - this.processingStartTime));
        }
        catch (InterruptedException e) {
            return;
        }
        this.dismiss();
    }
}

