/*
 * Decompiled with CFR 0.152.
 */
package org.ispeech;

import android.content.Context;
import android.content.Intent;
import android.media.AmrInputStream;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.apache.http.client.ClientProtocolException;
import org.ispeech.FreeformType;
import org.ispeech.MetaType;
import org.ispeech.Recognizer;
import org.ispeech.SpeechRecognizerEvent;
import org.ispeech.SpeechResult;
import org.ispeech.UtilitiesInternal;
import org.ispeech.core.InternalResources;
import org.ispeech.core.RecognizerDialog;
import org.ispeech.core.SilenceDetection;
import org.ispeech.core.SoundBox;
import org.ispeech.error.ApiException;
import org.ispeech.error.BusyException;
import org.ispeech.error.InvalidApiKeyException;
import org.ispeech.error.NoNetworkException;
import org.ispeech.iSpeechFramework;
import org.ispeech.tools.SerializableHashTable;
import org.ispeech.tools.Utilities;

class FreeformRecognizerImpl
implements Recognizer {
    private static final String TAG = "iSpeech SDK";
    private static final int MAX_SERVER_RESPONSE = 51200;
    private static FreeformRecognizerImpl _instance = null;
    private static final int FREQUENCY = 8000;
    private static final int MS_PER_FRAME = 20;
    private static final int SAMPLE_PER_FRAME = 160;
    private String mimeType = "audio/amr";
    private String _apiKey;
    private FreeformType freeFormValue = FreeformType.FREEFORM_SMS;
    long silenceStart = -1L;
    private static final int _version = 2;
    private static final int _model = 1;
    private static final int _type = 1;
    private SpeechRecognizerEvent recognizerEventListener = null;
    private Handler alertDialogHandler;
    private TimerTask timeoutTask;
    private long timeout = 60000L;
    private int socketTimeout = 60000;
    private SerializableHashTable meta;
    private Map<String, String> optionalCommands = new Hashtable<String, String>();
    private Map<String, List<String>> aliasList = new HashMap<String, List<String>>();
    private Vector<String> phraseList = new Vector();
    private boolean soundTone = true;
    private boolean isContinuous = false;
    int voiceCount = 0;
    private int MIN_RECORD_BUFF_SIZE = 4 * AudioRecord.getMinBufferSize((int)8000, (int)2, (int)2);
    private Context _context;
    private AudioManager audioManager;
    private AudioRecord audioRecorder;
    private VoiceDataTransporter voiceDataTransporter;
    private boolean silenceDetectOn;

    private Thread createEventThread(final SpeechRecognizerEvent.EventType type, final Object param) {
        Handler handler = new Handler(this._context.getMainLooper());
        Thread thread = new Thread(type.name()){

            public void run() {
                if (FreeformRecognizerImpl.this.recognizerEventListener != null) {
                    FreeformRecognizerImpl.this.recognizerEventListener.stateChanged(type, param);
                }
            }
        };
        handler.post((Runnable)thread);
        return thread;
    }

    private FreeformRecognizerImpl(Context context) throws InvalidApiKeyException {
        String apiKey = Utilities.getApiKey(context);
        if (apiKey == null || apiKey.length() != 32) {
            throw new InvalidApiKeyException();
        }
        this._apiKey = apiKey;
        this._context = context.getApplicationContext();
        this.meta = Utilities.getMetaInfo(context);
        SoundBox.getInstance(context);
        this.audioManager = (AudioManager)this._context.getSystemService("audio");
    }

    public void addAlias(String name, String[] values) {
        if (!this.aliasList.containsKey(name.toUpperCase())) {
            this.aliasList.put(name.toUpperCase(), new ArrayList());
        }
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            this.aliasList.get(name).add(value);
            ++n2;
        }
    }

    public void addCommand(String phrase) {
        if (!this.phraseList.contains(phrase)) {
            this.phraseList.add(phrase);
        }
    }

    public void addCommand(String[] phrases) {
        if (phrases != null) {
            String[] stringArray = phrases;
            int n = phrases.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                this.addCommand(s);
                ++n2;
            }
        }
    }

    public static FreeformRecognizerImpl getInstance(Context context) throws InvalidApiKeyException {
        if (_instance == null) {
            _instance = new FreeformRecognizerImpl(context);
        }
        return _instance;
    }

    public static FreeformRecognizerImpl getInstance(Context context, String apiKey) throws InvalidApiKeyException {
        if (_instance == null) {
            _instance = new FreeformRecognizerImpl(context);
        }
        return _instance;
    }

    public void setSilenceDetection(boolean newDetection) {
        this.silenceDetectOn = newDetection;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void addMeta(MetaType type, String value) {
        this.meta.put(type.getValue(), value);
    }

    public void addOptionalCommand(String command, String parameter) {
        this.optionalCommands.put(command, parameter);
    }

    private void removeOptionalCommand(String command) {
        if (this.optionalCommands.containsKey(command)) {
            this.optionalCommands.remove(command);
        }
    }

    public void clearOptionalCommand() {
        this.optionalCommands.clear();
    }

    public void setFreeForm(FreeformType freeFormType) {
        this.freeFormValue = freeFormType;
    }

    public void clearCommand() {
        throw new UnsupportedOperationException("Not implemented.");
    }

    public void stopRecord() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
        this.voiceDataTransporter.stopRecording();
    }

    void stopTimeoutTask() {
        if (this.timeoutTask != null) {
            this.timeoutTask.cancel();
        }
    }

    public void cancelRecord() {
        this.stopRecord();
        this.voiceDataTransporter.cancelRecording();
        this.voiceDataTransporter.interrupt();
        this.createEventThread(SpeechRecognizerEvent.EventType.RECORDING_CANCELED, null);
    }

    public void cancelProcessing() {
        if (this.voiceDataTransporter != null) {
            this.voiceDataTransporter.interrupt();
        }
        this.createEventThread(SpeechRecognizerEvent.EventType.RECOGNITION_CANCELED, null);
    }

    private void setupProcessingDialogHandler() {
        this.alertDialogHandler = new Handler(this._context.getMainLooper()){

            public void handleMessage(Message msg) {
                if (msg.what == 0) {
                    RecognizerDialog.getInstance().clearLayout();
                    RecognizerDialog.getInstance().dismiss();
                } else if (msg.what == 1) {
                    FreeformRecognizerImpl.this.showDialog();
                } else if (msg.what == 2) {
                    RecognizerDialog.getInstance().setRecognizing();
                } else if (msg.what == 3 && RecognizerDialog.getInstance() != null) {
                    RecognizerDialog.getInstance().setMicrophoneLevel(msg.arg1);
                }
            }
        };
    }

    private void setupRecordingTimeoutTask() {
        this.timeoutTask = new TimerTask(){

            public void run() {
                if (FreeformRecognizerImpl.this.audioRecorder != null && FreeformRecognizerImpl.this.audioRecorder.getState() == 1 && FreeformRecognizerImpl.this.audioRecorder.getState() == 3) {
                    FreeformRecognizerImpl.this.stopRecord();
                }
            }
        };
        new Timer().schedule(this.timeoutTask, this.timeout);
    }

    private void showDialog() {
        Intent i = new Intent(this._context, iSpeechFramework.class);
        i.putExtra("type", 0);
        i.putExtra("ispeech_api_key", this._apiKey);
        i.setFlags(0x10000000);
        this._context.startActivity(i);
    }

    private void playOpenSound() {
        if (this.soundTone) {
            SoundBox.getInstance(this._context).playOpen();
            try {
                Thread.sleep(800L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void startRecord(SpeechRecognizerEvent speechRecognizerEvent) throws BusyException, NoNetworkException {
        if (!UtilitiesInternal.hasFrameworkActivityDefinedInManifest(this._context)) {
            return;
        }
        if (!Utilities.isNetworkAvailable(this._context)) {
            throw new NoNetworkException("Network is not available.");
        }
        this.recognizerEventListener = speechRecognizerEvent;
        if (this.voiceDataTransporter != null && this.voiceDataTransporter.isRecording()) {
            this.createEventThread(SpeechRecognizerEvent.EventType.ERROR, new IllegalStateException("Device is busy?"));
            this.voiceDataTransporter.cancelRecording();
            this.voiceDataTransporter.interrupt();
            return;
        }
        this.silenceStart = -1L;
        this.setupProcessingDialogHandler();
        this.alertDialogHandler.sendEmptyMessage(1);
        this.setupRecordingTimeoutTask();
        this.voiceDataTransporter = new VoiceDataTransporter();
        this.voiceDataTransporter.start();
        this.playOpenSound();
        RecognizerDialog.getInstance().startDraw();
    }

    public FreeformType getFreeForm() {
        return this.freeFormValue;
    }

    public boolean isRunning() {
        return this.voiceDataTransporter != null && this.voiceDataTransporter.isAlive();
    }

    public void clearAlias() {
        throw new UnsupportedOperationException("Unsupported operation.");
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void enableSoundTone() {
        this.soundTone = true;
    }

    public void disableSoundTone() {
        this.soundTone = false;
    }

    public void setModel(String model) {
        if (model != null) {
            this.addOptionalCommand("model", model);
        } else {
            this.removeOptionalCommand("model");
        }
    }

    public void setLocale(String locale) {
        if (locale != null) {
            this.addOptionalCommand("locale", locale);
        } else {
            this.removeOptionalCommand("locale");
        }
    }

    public void setChime(boolean isOn) {
        if (isOn) {
            this.enableSoundTone();
        } else {
            this.disableSoundTone();
        }
    }

    private class VoiceDataTransporter
    extends Thread {
        private Socket serverConnection;
        private OutputStream toServer = null;
        private InputStream fromServer = null;
        private boolean isPrepared = false;
        private ByteArrayOutputStream audioBuffer = new ByteArrayOutputStream();
        private final int AUDIO_PACKET_SIZE = 1000;
        private final int RECORDING_INTERVAL = 5000;
        private long lastSendTime = 0L;
        private boolean isStopped = false;
        private boolean isCanceled = false;

        private VoiceDataTransporter() {
        }

        private void commit() throws IOException {
            this.sendPacket(this.audioBuffer.toByteArray(), false);
            this.audioBuffer.reset();
        }

        private synchronized void write(byte[] data, int offset, int length) throws IOException {
            this.audioBuffer.write(data, offset, length);
            if (this.audioBuffer.size() >= 1000) {
                this.commit();
            }
        }

        private void stopStreaming() throws IOException {
            this.commit();
            this.audioBuffer.close();
        }

        public boolean isRecording() {
            return !this.isStopped;
        }

        public void stopRecording() {
            this.isStopped = true;
            FreeformRecognizerImpl.this.isContinuous = false;
        }

        public void cancelRecording() {
            this.stopRecording();
            this.isCanceled = true;
        }

        public boolean isRecordingCanceled() {
            return this.isCanceled;
        }

        private synchronized void sendPacket(byte[] postData, boolean firstPacket) throws UnsupportedEncodingException, IOException {
            if (this.toServer == null) {
                return;
            }
            if (firstPacket) {
                this.toServer.write("iSpeech".getBytes("utf8"));
            }
            this.toServer.write(new byte[]{2, 1, 1});
            this.toServer.write(this.intToByteArray(postData.length));
            this.toServer.write(postData);
        }

        private void sendLastASRPacket() throws IOException {
            this.toServer.write(new byte[]{2, 1, 1});
            this.toServer.write(this.intToByteArray(0));
            this.toServer.flush();
        }

        private byte[] intToByteArray(int number) {
            byte[] ret = new byte[]{(byte)(number >> 24 & 0xFF), (byte)(number >> 16 & 0xFF), (byte)(number >> 8 & 0xFF), (byte)(number & 0xFF)};
            return ret;
        }

        private int byteArrayToInt(byte[] buffer) {
            return (buffer[3] & 0xFF) + ((buffer[2] & 0xFF) << 8) + ((buffer[1] & 0xFF) << 16) + ((buffer[0] & 0xFF) << 24);
        }

        private SerializableHashTable getASRResponse() throws IOException, ApiException {
            byte[] buffer = new byte[4];
            this.fromServer.read(buffer, 0, 3);
            int bytesRead = this.fromServer.read(buffer);
            if (bytesRead == -1) {
                throw new ApiException("No response, reached end of stream");
            }
            int sizeOfResponse = 0;
            sizeOfResponse = this.byteArrayToInt(buffer);
            if (sizeOfResponse != 0 && sizeOfResponse < 51200) {
                ByteBuffer tmp = ByteBuffer.allocate(sizeOfResponse);
                buffer = new byte[4096];
                while (sizeOfResponse > 0) {
                    int read = this.fromServer.read(buffer, 0, buffer.length);
                    tmp.put(buffer, 0, read);
                    sizeOfResponse -= read;
                }
                return SerializableHashTable.deserialize(tmp.array());
            }
            if (sizeOfResponse > 51200) {
                Log.e((String)FreeformRecognizerImpl.TAG, (String)("Server response too large: " + String.valueOf(sizeOfResponse) + ". Check your key and/or freeform/model types."));
            }
            return null;
        }

        public void run() {
            try {
                this.connectToHost();
                if (this.isInterrupted()) {
                    return;
                }
                try {
                    SerializableHashTable response = this.getASRResponse();
                    if (response != null) {
                        FreeformRecognizerImpl.this.stopRecord();
                        throw new ApiException(response.containsKey("message") ? response.getString("message") : "Bad response from the server");
                    }
                    FreeformRecognizerImpl.this.audioManager.setStreamSolo(InternalResources.STREAM_TYPE, true);
                    FreeformRecognizerImpl.this.audioRecorder = new AudioRecord(1, 8000, 2, 2, FreeformRecognizerImpl.this.MIN_RECORD_BUFF_SIZE);
                    FreeformRecognizerImpl.this.audioRecorder.startRecording();
                    byte[] rawAudioBuffer = new byte[FreeformRecognizerImpl.this.MIN_RECORD_BUFF_SIZE];
                    byte[] amrBuffer = new byte[192];
                    int bytesRead = 1;
                    while (!this.isStopped) {
                        bytesRead = FreeformRecognizerImpl.this.audioRecorder.read(rawAudioBuffer, 0, rawAudioBuffer.length);
                        if (bytesRead == -1) break;
                        RecognizerDialog.getInstance().setMicrophoneLevel(SilenceDetection.getEnergy(rawAudioBuffer));
                        ByteArrayInputStream bis = new ByteArrayInputStream(rawAudioBuffer, 0, bytesRead);
                        AmrInputStream amrInputStream = new AmrInputStream(bis);
                        while (bytesRead > 0) {
                            bytesRead = amrInputStream.read(amrBuffer, 0, amrBuffer.length);
                            if (bytesRead <= 0) continue;
                            this.write(amrBuffer, 0, bytesRead);
                        }
                        amrInputStream.close();
                    }
                    FreeformRecognizerImpl.this.audioRecorder.stop();
                    FreeformRecognizerImpl.this.audioRecorder.release();
                    this.stopStreaming();
                    this.sendLastASRPacket();
                    if (FreeformRecognizerImpl.this.soundTone) {
                        SoundBox.getInstance(FreeformRecognizerImpl.this._context).playClose();
                    }
                    FreeformRecognizerImpl.this.alertDialogHandler.sendEmptyMessage(2);
                    FreeformRecognizerImpl.this.createEventThread(SpeechRecognizerEvent.EventType.RECORDING_COMPLETE, null);
                    response = this.getASRResponse();
                    this.parseResults(response);
                }
                catch (ClientProtocolException e) {
                    e.printStackTrace();
                    FreeformRecognizerImpl.this.createEventThread(SpeechRecognizerEvent.EventType.ERROR, (Object)e);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    FreeformRecognizerImpl.this.createEventThread(SpeechRecognizerEvent.EventType.ERROR, e);
                }
                catch (ApiException e) {
                    e.printStackTrace();
                    FreeformRecognizerImpl.this.createEventThread(SpeechRecognizerEvent.EventType.ERROR, e);
                }
                catch (InvalidApiKeyException e) {
                    e.printStackTrace();
                }
            }
            finally {
                FreeformRecognizerImpl.this.audioManager.setStreamSolo(InternalResources.STREAM_TYPE, false);
                FreeformRecognizerImpl.this.timeoutTask.cancel();
                FreeformRecognizerImpl.this.voiceCount = 0;
            }
        }

        private void connectToHost() throws UnsupportedEncodingException, IOException, ApiException {
            this.serverConnection = new Socket();
            this.serverConnection.setSoTimeout(FreeformRecognizerImpl.this.socketTimeout);
            this.serverConnection.connect(new InetSocketAddress(InternalResources.getASRDomain(FreeformRecognizerImpl.this._context), 80));
            if (!this.serverConnection.isConnected()) {
                throw new ApiException("Could not connect to host");
            }
            this.toServer = this.serverConnection.getOutputStream();
            this.fromServer = this.serverConnection.getInputStream();
            this.sendPacket(this.buildURL().getBytes("UTF-8"), true);
        }

        private void parseResults(SerializableHashTable results) throws InvalidApiKeyException, IOException, ApiException {
            SpeechResult asrResult = null;
            if (results.containsKey("result") && results.getString("result").equals("success")) {
                asrResult = new SpeechResult(results.getString("text"), Float.parseFloat(results.getString("confidence")));
            } else if (results.containsKey("result") && results.getString("result").equals("error")) {
                if (results.containsKey("code")) {
                    int code = Integer.parseInt(results.getString("code"));
                    switch (code) {
                        case 1: {
                            RecognizerDialog.getInstance().dismiss();
                            break;
                        }
                        case 3: {
                            break;
                        }
                        case 101: {
                            break;
                        }
                        case 999: {
                            throw new InvalidApiKeyException();
                        }
                        default: {
                            throw new IOException();
                        }
                    }
                }
                throw new ApiException(results.getString("message"));
            }
            if (this.isInterrupted() || FreeformRecognizerImpl.this.voiceDataTransporter.isRecordingCanceled()) {
                return;
            }
            FreeformRecognizerImpl.this.createEventThread(SpeechRecognizerEvent.EventType.RECOGNITION_COMPLETE, asrResult);
            FreeformRecognizerImpl.this.alertDialogHandler.sendEmptyMessage(0);
        }

        private String buildURL() throws UnsupportedEncodingException {
            String ret = "apikey=" + FreeformRecognizerImpl.this._apiKey;
            ret = String.valueOf(ret) + "&action=recognize";
            ret = String.valueOf(ret) + "&freeform=1";
            ret = String.valueOf(ret) + "&deviceType=Android";
            ret = String.valueOf(ret) + "&locale=en-us";
            ret = String.valueOf(ret) + "&output=hash";
            ArrayList<String> alias = new ArrayList<String>();
            int limit = FreeformRecognizerImpl.this.phraseList.size();
            int x = 0;
            while (x < limit) {
                ret = String.valueOf(ret) + "&command" + (x + 1) + "=" + URLEncoder.encode((String)FreeformRecognizerImpl.this.phraseList.get(x), "UTF-8");
                alias.add("command" + (x + 1));
                ++x;
            }
            if (FreeformRecognizerImpl.this.aliasList.size() > 0) {
                Iterator it = FreeformRecognizerImpl.this.aliasList.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry pairs = it.next();
                    ret = String.valueOf(ret) + "&" + ((String)pairs.getKey()).toUpperCase(Locale.US) + "=" + this.pipeSeparateArray(((List)pairs.getValue()).toArray(new String[((List)pairs.getValue()).size()]));
                    alias.add(((String)pairs.getKey()).toUpperCase(Locale.US));
                    it.remove();
                }
            }
            if (alias.size() > 0) {
                ret = String.valueOf(ret) + "&alias=" + this.pipeSeparateArray(alias.toArray(new String[alias.size()]));
            }
            for (String key : FreeformRecognizerImpl.this.optionalCommands.keySet()) {
                String value = (String)FreeformRecognizerImpl.this.optionalCommands.get(key);
                ret = String.valueOf(ret) + "&" + URLEncoder.encode(key) + "=" + URLEncoder.encode(value);
            }
            return ret;
        }

        private String pipeSeparateArray(String[] arr) throws UnsupportedEncodingException {
            String ret = String.valueOf(URLEncoder.encode(arr[0], "UTF-8")) + "|";
            int limit = arr.length;
            int x = 1;
            while (x < limit - 1) {
                ret = String.valueOf(ret) + URLEncoder.encode(arr[x], "UTF-8") + "|";
                ++x;
            }
            return String.valueOf(ret) + URLEncoder.encode(arr[limit - 1], "UTF-8");
        }
    }
}

