/*
 * Decompiled with CFR 0.152.
 */
package DrawImage;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import java.io.InputStream;

public class DrawCanvas
extends RelativeLayout {
    private Context myContext;
    private Activity ownerActivity;
    private ProgressBar loadingBar;
    private DrawMicrophone microphone;
    private Rect volumeBar;
    private Paint volumeBarPaint;
    private int width;
    private int height;
    private int yHighest = 0;
    private int yLowest = 100000;
    private int yAverage = 0;
    private int totalY = 0;
    private int volumeBarPercent = 0;
    private long lastTime = System.currentTimeMillis();
    private int deltaTime = 0;
    private int maxMove = 0;
    private int volumeBarGoal = 0;
    private int volumeBarHeight = 0;
    private float maxMovePercent;
    private int yOffset = 0;
    private final float PercentPerMilis = 0.35f;

    public DrawCanvas(Context context) {
        super(context);
        this.init(context, 0);
    }

    public DrawCanvas(Context context, int nWidth) {
        super(context);
        this.init(context, nWidth);
    }

    private void init(Context context, int nWidth) {
        this.myContext = context;
        this.width = nWidth;
        this.setFocusable(true);
        this.setBackgroundResource(17170446);
        this.loadingBar = new ProgressBar(this.myContext, null, 16842874);
        RelativeLayout.LayoutParams loadingBarLayoutParams = new RelativeLayout.LayoutParams(-2, -2);
        loadingBarLayoutParams.addRule(14);
        this.loadingBar.setLayoutParams((ViewGroup.LayoutParams)loadingBarLayoutParams);
        this.addView((View)this.loadingBar);
        this.loadingBar.setVisibility(0);
        this.microphone = new DrawMicrophone(this.myContext);
        this.ownerActivity = (Activity)context;
    }

    public void setY(int y) {
        this.yOffset = y > 0 && y > this.yOffset ? y : this.yOffset;
        int n = y = (y -= this.yOffset) >= 0 ? y : -y;
        if (this.yHighest < y) {
            this.yHighest = y;
        }
        if (y > this.yAverage / 2) {
            this.yAverage = (this.yAverage * this.totalY + y) / (this.totalY + 1);
            ++this.totalY;
            this.yLowest = this.yAverage / 2;
        }
        if (this.yHighest == this.yLowest) {
            return;
        }
        y = y - this.yLowest > 0 ? y - this.yLowest : 0;
        this.volumeBarPercent = y * 100 / (this.yHighest - this.yLowest);
    }

    public int getVolumeBarHeight() {
        this.deltaTime = (int)(System.currentTimeMillis() - this.lastTime);
        this.lastTime = System.currentTimeMillis();
        this.maxMovePercent = (float)this.deltaTime * 0.35f;
        this.maxMove = (int)(this.maxMovePercent * (float)this.height) / 100;
        if (this.closeTo(this.volumeBarGoal, this.volumeBarHeight, 15 * this.height / 100)) {
            this.volumeBarGoal = this.volumeBarPercent * this.height / 100;
            this.volumeBarGoal -= this.height;
            this.volumeBarGoal *= -1;
        }
        if (this.volumeBarGoal > this.volumeBarHeight) {
            this.volumeBarHeight = this.volumeBarHeight + this.maxMove >= this.volumeBarGoal ? this.volumeBarGoal : this.volumeBarHeight + this.maxMove;
        } else if (this.volumeBarGoal < this.volumeBarHeight) {
            this.volumeBarHeight = this.volumeBarHeight - this.maxMove <= this.volumeBarGoal ? this.volumeBarGoal : this.volumeBarHeight - this.maxMove;
        }
        return this.volumeBarHeight;
    }

    private boolean closeTo(int first, int second, int range) {
        if (first == second) {
            return true;
        }
        if (first > second && first - range <= second) {
            return true;
        }
        return first < second && first + range >= second;
    }

    public void setProcessing() {
        this.ownerActivity.runOnUiThread(new Runnable(){

            public void run() {
                DrawCanvas.this.microphone.setVisibility(8);
                DrawCanvas.this.setBackgroundResource(17170446);
                DrawCanvas.this.loadingBar.setVisibility(0);
            }
        });
    }

    public void startDrawImage() {
        this.ownerActivity.runOnUiThread(new Runnable(){

            public void run() {
                DrawCanvas.this.loadingBar.setVisibility(8);
                DrawCanvas.this.addView((View)DrawCanvas.this.microphone);
                DrawCanvas.this.microphone.setVisibility(0);
            }
        });
    }

    public void setOwnerActivity(Activity activity) {
        this.ownerActivity = activity;
    }

    private class DrawMicrophone
    extends SurfaceView
    implements SurfaceHolder.Callback {
        private Bitmap microphoneImage;
        private boolean canDraw;
        private CanvasThread canvasThread;
        int drawHeight;

        public DrawMicrophone(Context context) {
            super(context);
            this.canDraw = false;
            this.loadImage();
            this.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(this.microphoneImage.getWidth(), this.microphoneImage.getHeight()));
            this.setWillNotDraw(false);
            this.getHolder().addCallback((SurfaceHolder.Callback)this);
        }

        private Bitmap scaleBitmap(Bitmap src) {
            float wToH = (float)src.getHeight() / (float)src.getWidth();
            int height = (int)((float)DrawCanvas.this.width * wToH);
            return Bitmap.createScaledBitmap((Bitmap)src, (int)DrawCanvas.this.width, (int)height, (boolean)false);
        }

        private void loadImage() {
            this.microphoneImage = BitmapFactory.decodeStream((InputStream)DrawCanvas.class.getClassLoader().getResourceAsStream("org/ispeech/raw/microphone_back_v_7.png"));
            this.microphoneImage = this.scaleBitmap(this.microphoneImage);
        }

        public void onDraw(Canvas canvas) {
            if (!this.canDraw) {
                return;
            }
            canvas.drawColor(-16777216);
            DrawCanvas.this.height = canvas.getHeight();
            this.drawHeight = DrawCanvas.this.getVolumeBarHeight();
            DrawCanvas.this.volumeBar.set(0, this.drawHeight, DrawCanvas.this.width, DrawCanvas.this.height);
            canvas.drawRect(DrawCanvas.this.volumeBar, DrawCanvas.this.volumeBarPaint);
            canvas.drawCircle((float)(DrawCanvas.this.width / 2), (float)this.drawHeight, (float)(DrawCanvas.this.width / 4), DrawCanvas.this.volumeBarPaint);
            canvas.drawBitmap(this.microphoneImage, 0.0f, 0.0f, null);
        }

        public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        }

        public void surfaceCreated(SurfaceHolder holder) {
            DrawCanvas.this.volumeBar = new Rect();
            DrawCanvas.this.volumeBarPaint = new Paint();
            DrawCanvas.this.volumeBarPaint.setColor(-1);
            this.canvasThread = new CanvasThread(holder);
            this.canvasThread.setRunning(true);
            this.canvasThread.start();
        }

        public void surfaceDestroyed(SurfaceHolder holder) {
            this.canvasThread.setRunning(false);
        }

        private class CanvasThread
        extends Thread {
            private boolean isRunning = false;
            SurfaceHolder mySurfaceHolder;
            Canvas myCanvas;

            CanvasThread(SurfaceHolder holder) {
                this.mySurfaceHolder = holder;
            }

            public void setRunning(boolean run) {
                this.isRunning = run;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (this.isRunning) {
                    this.myCanvas = null;
                    try {
                        this.myCanvas = this.mySurfaceHolder.lockCanvas();
                        if (this.myCanvas == null) continue;
                        SurfaceHolder surfaceHolder = this.mySurfaceHolder;
                        synchronized (surfaceHolder) {
                            DrawMicrophone.this.canDraw = true;
                            DrawCanvas.this.microphone.draw(this.myCanvas);
                            DrawMicrophone.this.canDraw = false;
                        }
                    }
                    finally {
                        if (this.myCanvas != null) {
                            this.mySurfaceHolder.unlockCanvasAndPost(this.myCanvas);
                        }
                    }
                }
            }
        }
    }
}

